/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.type.field;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import io.logansquarex.processor.type.Type;
import io.logansquarex.processor.type.field.FieldType;
import java.util.ArrayList;
import java.util.List;

public class ParameterizedTypeField
extends FieldType {
    private final TypeName mTypeName;
    private String mJsonMapperVariableName;

    public ParameterizedTypeField(TypeName typeName) {
        this.mTypeName = typeName;
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        setter = ParameterizedTypeField.replaceLastLiteral(setter, String.format("%s.parse($L)", this.mJsonMapperVariableName));
        builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
    }

    @Override
    public void serialize(MethodSpec.Builder builder, int depth, String fieldName, List<String> processedFieldNames, String getter, boolean isObjectProperty, boolean checkIfNull, boolean writeIfNull, boolean writeCollectionElementIfNull) {
        if (checkIfNull) {
            builder.beginControlFlow("if ($L != null)", new Object[]{getter});
        }
        if (isObjectProperty) {
            builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
        }
        builder.addStatement("$L.serialize($L, $L, true)", new Object[]{this.mJsonMapperVariableName, getter, "jsonGenerator"});
        if (checkIfNull) {
            if (writeIfNull) {
                builder.nextControlFlow("else", new Object[0]);
                if (isObjectProperty) {
                    builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
                }
                builder.addStatement("$L.writeNull()", new Object[]{"jsonGenerator"});
            }
            builder.endControlFlow();
        }
    }

    @Override
    public String getParameterizedTypeString() {
        if (this.parameterTypes.size() > 0) {
            StringBuilder string = new StringBuilder("$T<");
            for (int i = 0; i < this.parameterTypes.size(); ++i) {
                if (i > 0) {
                    string.append(", ");
                }
                string.append(((Type)this.parameterTypes.get(i)).getParameterizedTypeString());
            }
            string.append('>');
            return string.toString();
        }
        return "$T";
    }

    @Override
    public Object[] getParameterizedTypeStringArgs() {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.mTypeName);
        for (Type parameterType : this.parameterTypes) {
            args.add(parameterType.getParameterizedTypeStringArgs());
        }
        return args.toArray(new Object[args.size()]);
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return this.mTypeName;
    }

    @Override
    public TypeName getTypeName() {
        return this.mTypeName;
    }

    public void setJsonMapperVariableName(String jsonMapperVariableName) {
        this.mJsonMapperVariableName = jsonMapperVariableName;
    }

    public String getParameterName() {
        return this.mTypeName.toString();
    }
}

