/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.type.field;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import io.logansquarex.core.annotation.JsonObject;
import io.logansquarex.processor.type.Type;
import io.logansquarex.processor.type.field.BooleanFieldType;
import io.logansquarex.processor.type.field.ByteFieldType;
import io.logansquarex.processor.type.field.DoubleFieldType;
import io.logansquarex.processor.type.field.DynamicFieldType;
import io.logansquarex.processor.type.field.FloatFieldType;
import io.logansquarex.processor.type.field.IntegerFieldType;
import io.logansquarex.processor.type.field.JsonFieldType;
import io.logansquarex.processor.type.field.LongFieldType;
import io.logansquarex.processor.type.field.StringFieldType;
import io.logansquarex.processor.type.field.TypeConverterFieldType;
import io.logansquarex.processor.type.field.UnknownFieldType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class FieldType
extends Type {
    public abstract TypeName getNonPrimitiveTypeName();

    @Override
    public String getParameterizedTypeString() {
        return "$T";
    }

    @Override
    public Object[] getParameterizedTypeStringArgs() {
        return new Object[]{this.getNonPrimitiveTypeName()};
    }

    public static FieldType fieldTypeFor(TypeMirror typeMirror, TypeMirror typeConverterType, Elements elements, Types types) {
        if (typeMirror != null) {
            JsonObject annotation;
            if (typeConverterType != null && !"void".equals(typeConverterType.toString())) {
                return new TypeConverterFieldType(TypeName.get((TypeMirror)typeMirror), ClassName.bestGuess((String)typeConverterType.toString()));
            }
            if (typeMirror.getKind() == TypeKind.BOOLEAN) {
                return new BooleanFieldType(true);
            }
            if (Boolean.class.getCanonicalName().equals(typeMirror.toString())) {
                return new BooleanFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.BYTE) {
                return new ByteFieldType(true);
            }
            if (Byte.class.getCanonicalName().equals(typeMirror.toString())) {
                return new ByteFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.INT) {
                return new IntegerFieldType(true);
            }
            if (Integer.class.getCanonicalName().equals(typeMirror.toString())) {
                return new IntegerFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.LONG) {
                return new LongFieldType(true);
            }
            if (Long.class.getCanonicalName().equals(typeMirror.toString())) {
                return new LongFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.FLOAT) {
                return new FloatFieldType(true);
            }
            if (Float.class.getCanonicalName().equals(typeMirror.toString())) {
                return new FloatFieldType(false);
            }
            if (typeMirror.getKind() == TypeKind.DOUBLE) {
                return new DoubleFieldType(true);
            }
            if (Double.class.getCanonicalName().equals(typeMirror.toString())) {
                return new DoubleFieldType(false);
            }
            if (String.class.getCanonicalName().equals(typeMirror.toString())) {
                return new StringFieldType();
            }
            if (Object.class.getCanonicalName().equals(typeMirror.toString())) {
                return new UnknownFieldType();
            }
            if (typeMirror instanceof DeclaredType && (annotation = ((DeclaredType)typeMirror).asElement().getAnnotation(JsonObject.class)) != null) {
                return new JsonFieldType(ClassName.bestGuess((String)typeMirror.toString()));
            }
            return new DynamicFieldType(TypeName.get((TypeMirror)typeMirror));
        }
        return null;
    }

    protected static String replaceLastLiteral(String string, String replacement) {
        int pos = string.lastIndexOf("$L");
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + 2, string.length());
        }
        return string;
    }
}

