/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.type;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import io.logansquarex.processor.type.collection.ArrayCollectionType;
import io.logansquarex.processor.type.collection.CollectionType;
import io.logansquarex.processor.type.field.FieldType;
import io.logansquarex.processor.type.field.ParameterizedTypeField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class Type {
    public final List<Type> parameterTypes = new ArrayList<Type>();

    public abstract TypeName getTypeName();

    public abstract String getParameterizedTypeString();

    public abstract Object[] getParameterizedTypeStringArgs();

    public abstract void parse(MethodSpec.Builder var1, int var2, String var3, Object ... var4);

    public abstract void serialize(MethodSpec.Builder var1, int var2, String var3, List<String> var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9);

    public static Type typeFor(TypeMirror typeMirror, TypeMirror typeConverterType, Elements elements, Types types) {
        Type type;
        boolean hasTypeConverter;
        TypeMirror genericClassTypeMirror = types.erasure(typeMirror);
        boolean bl = hasTypeConverter = typeConverterType != null && !typeConverterType.toString().equals("void");
        if (!hasTypeConverter && typeMirror instanceof ArrayType) {
            TypeMirror arrayTypeMirror = ((ArrayType)typeMirror).getComponentType();
            type = new ArrayCollectionType(Type.typeFor(arrayTypeMirror, null, elements, types));
        } else if (!hasTypeConverter && !genericClassTypeMirror.toString().equals(typeMirror.toString())) {
            type = CollectionType.collectionTypeFor(typeMirror, genericClassTypeMirror, elements, types);
            if (type == null) {
                if (typeMirror.toString().contains("?")) {
                    throw new RuntimeException("Generic types with wildcards are currently not supported by LoganSquare.");
                }
                try {
                    type = new ParameterizedTypeField(TypeName.get((TypeMirror)typeMirror));
                }
                catch (Exception exception) {}
            }
        } else {
            type = FieldType.fieldTypeFor(typeMirror, typeConverterType, elements, types);
        }
        return type;
    }

    protected Object[] expandStringArgs(Object ... args) {
        ArrayList<Object> argList = new ArrayList<Object>();
        for (Object arg : args) {
            if (arg instanceof Object[]) {
                Collections.addAll(argList, (Object[])arg);
                continue;
            }
            argList.add(arg);
        }
        return argList.toArray(new Object[argList.size()]);
    }

    public void addParameterTypes(List<TypeMirror> parameterTypes, Elements elements, Types types) {
        for (TypeMirror typeMirror : parameterTypes) {
            this.addParameterType(typeMirror, elements, types);
        }
    }

    public void addParameterType(Type type) {
        this.parameterTypes.add(type);
    }

    public void addParameterType(TypeMirror parameterType, Elements elements, Types types) {
        this.parameterTypes.add(Type.typeFor(parameterType, null, elements, types));
    }

    public Set<ClassNameObjectMapper> getUsedJsonObjectMappers() {
        HashSet<ClassNameObjectMapper> set = new HashSet<ClassNameObjectMapper>();
        for (Type parameterType : this.parameterTypes) {
            set.addAll(parameterType.getUsedJsonObjectMappers());
        }
        return set;
    }

    public Set<TypeName> getUsedTypeConverters() {
        HashSet<TypeName> set = new HashSet<TypeName>();
        for (Type parameterType : this.parameterTypes) {
            set.addAll(parameterType.getUsedTypeConverters());
        }
        return set;
    }

    public static class ClassNameObjectMapper {
        public final ClassName className;
        public final String objectMapper;

        public ClassNameObjectMapper(ClassName className, String objectMapper) {
            this.className = className;
            this.objectMapper = objectMapper;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.objectMapper.equals(((ClassNameObjectMapper)o).objectMapper);
        }

        public int hashCode() {
            return this.objectMapper.hashCode();
        }
    }
}

