/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.processor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import io.logansquarex.core.JsonMapper;
import io.logansquarex.core.LoganSquareX;
import io.logansquarex.core.ParameterizedType;
import io.logansquarex.core.typeconverters.TypeConverter;
import io.logansquarex.core.util.SimpleArrayMap;
import io.logansquarex.processor.processor.JsonFieldHolder;
import io.logansquarex.processor.processor.JsonObjectHolder;
import io.logansquarex.processor.processor.TextUtils;
import io.logansquarex.processor.type.Type;
import io.logansquarex.processor.type.field.ParameterizedTypeField;
import io.logansquarex.processor.type.field.TypeConverterFieldType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeVariable;

public class ObjectMapperInjector {
    public static final String PARENT_OBJECT_MAPPER_VARIABLE_NAME = "parentObjectMapper";
    public static final String JSON_PARSER_VARIABLE_NAME = "jsonParser";
    public static final String JSON_GENERATOR_VARIABLE_NAME = "jsonGenerator";
    private final JsonObjectHolder mJsonObjectHolder;

    public ObjectMapperInjector(JsonObjectHolder jsonObjectHolder) {
        this.mJsonObjectHolder = jsonObjectHolder;
    }

    public String getJavaClassFile() {
        try {
            return JavaFile.builder((String)this.mJsonObjectHolder.packageName, (TypeSpec)this.getTypeSpec()).build().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TypeSpec getTypeSpec() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.mJsonObjectHolder.injectedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        builder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "\"unsafe,unchecked\"", new Object[0]).build());
        builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonMapper.class), (TypeName[])new TypeName[]{this.mJsonObjectHolder.objectTypeName}));
        for (TypeParameterElement typeParameterElement : this.mJsonObjectHolder.typeParameters) {
            builder.addTypeVariable(TypeVariableName.get((TypeVariable)((TypeVariable)typeParameterElement.asType())));
        }
        if (this.mJsonObjectHolder.hasParentClass()) {
            FieldSpec.Builder parentMapperBuilder;
            if (this.mJsonObjectHolder.parentTypeParameters.size() == 0) {
                parentMapperBuilder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonMapper.class), (TypeName[])new TypeName[]{this.mJsonObjectHolder.parentTypeName}), (String)PARENT_OBJECT_MAPPER_VARIABLE_NAME, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.mapperFor($T.class)", new Object[]{LoganSquareX.class, this.mJsonObjectHolder.parentTypeName});
            } else {
                parentMapperBuilder = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonMapper.class), (TypeName[])new TypeName[]{this.mJsonObjectHolder.getParameterizedParentTypeName()}), (String)PARENT_OBJECT_MAPPER_VARIABLE_NAME, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
                if (this.mJsonObjectHolder.typeParameters.size() == 0) {
                    parentMapperBuilder.initializer("$T.mapperFor(new $T<$T>() { })", new Object[]{LoganSquareX.class, ParameterizedType.class, this.mJsonObjectHolder.getParameterizedParentTypeName()});
                }
            }
            builder.addField(parentMapperBuilder.build());
        }
        HashSet<ClassName> typeConvertersUsed = new HashSet<ClassName>();
        for (JsonFieldHolder fieldHolder : this.mJsonObjectHolder.fieldMap.values()) {
            if (!(fieldHolder.type instanceof TypeConverterFieldType)) continue;
            typeConvertersUsed.add(((TypeConverterFieldType)fieldHolder.type).getTypeConverterClassName());
        }
        for (ClassName typeConverter : typeConvertersUsed) {
            builder.addField(FieldSpec.builder((TypeName)typeConverter, (String)ObjectMapperInjector.getStaticFinalTypeConverterVariableName((TypeName)typeConverter), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{typeConverter}).build());
        }
        MethodSpec.Builder builder2 = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        ArrayList<String> createdJsonMappers = new ArrayList<String>();
        if (this.mJsonObjectHolder.typeParameters.size() > 0) {
            builder2.addParameter((TypeName)ClassName.get(ParameterizedType.class), "type", new Modifier[0]);
            builder2.addStatement("partialMappers.put(type, this)", new Object[0]);
            for (TypeParameterElement typeParameterElement : this.mJsonObjectHolder.typeParameters) {
                String typeName = typeParameterElement.getSimpleName().toString();
                String typeArgumentName = typeName + "Type";
                String jsonMapperVariableName = this.getJsonMapperVariableNameForTypeParameter(typeName);
                if (createdJsonMappers.contains(jsonMapperVariableName)) continue;
                createdJsonMappers.add(jsonMapperVariableName);
                builder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonMapper.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)typeName)}), (String)jsonMapperVariableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
                builder2.addParameter((TypeName)ClassName.get(ParameterizedType.class), typeArgumentName, new Modifier[0]);
                builder2.addStatement("$L = $T.mapperFor($L, partialMappers)", new Object[]{jsonMapperVariableName, LoganSquareX.class, typeArgumentName});
            }
            builder2.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SimpleArrayMap.class), (TypeName[])new TypeName[]{ClassName.get(ParameterizedType.class), ClassName.get(JsonMapper.class)}), "partialMappers", new Modifier[0]);
        }
        for (JsonFieldHolder jsonFieldHolder : this.mJsonObjectHolder.fieldMap.values()) {
            String jsonMapperVariableName;
            if (!(jsonFieldHolder.type instanceof ParameterizedTypeField) || createdJsonMappers.contains(jsonMapperVariableName = this.getJsonMapperVariableNameForTypeParameter(((ParameterizedTypeField)jsonFieldHolder.type).getParameterName()))) continue;
            ParameterizedTypeName parameterizedType = ParameterizedTypeName.get((ClassName)ClassName.get(JsonMapper.class), (TypeName[])new TypeName[]{jsonFieldHolder.type.getTypeName()});
            createdJsonMappers.add(jsonMapperVariableName);
            builder.addField(FieldSpec.builder((TypeName)parameterizedType, (String)jsonMapperVariableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            String typeName = jsonMapperVariableName + "Type";
            builder2.addStatement("$T $L = new $T<$T>() { }", new Object[]{ParameterizedType.class, typeName, ParameterizedType.class, jsonFieldHolder.type.getTypeName()});
            if (this.mJsonObjectHolder.typeParameters.size() > 0) {
                builder2.beginControlFlow("if ($L.equals(type))", new Object[]{typeName});
                builder2.addStatement("$L = ($T)this", new Object[]{jsonMapperVariableName, JsonMapper.class});
                builder2.nextControlFlow("else", new Object[0]);
                builder2.addStatement("$L = $T.mapperFor($L, partialMappers)", new Object[]{jsonMapperVariableName, LoganSquareX.class, typeName});
                builder2.endControlFlow();
                continue;
            }
            builder2.addStatement("$L = $T.mapperFor($L)", new Object[]{jsonMapperVariableName, LoganSquareX.class, typeName});
        }
        if (createdJsonMappers.size() > 0) {
            if (this.mJsonObjectHolder.hasParentClass()) {
                builder2.addStatement("$L = $T.mapperFor(new $T<$T>() { })", new Object[]{PARENT_OBJECT_MAPPER_VARIABLE_NAME, LoganSquareX.class, ParameterizedType.class, this.mJsonObjectHolder.getParameterizedParentTypeName()});
            }
            builder.addMethod(builder2.build());
        }
        builder.addMethod(this.getParseMethod());
        builder.addMethod(this.getParseFieldMethod());
        builder.addMethod(this.getSerializeMethod());
        this.addUsedJsonMapperVariables(builder);
        this.addUsedTypeConverterMethods(builder);
        return builder.build();
    }

    private MethodSpec getParseMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"parse").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.mJsonObjectHolder.objectTypeName).addParameter(JsonParser.class, JSON_PARSER_VARIABLE_NAME, new Modifier[0]).addException(IOException.class);
        if (!this.mJsonObjectHolder.isAbstractClass) {
            builder.addStatement("$T instance = new $T()", new Object[]{this.mJsonObjectHolder.objectTypeName, this.mJsonObjectHolder.objectTypeName}).beginControlFlow("if ($L.getCurrentToken() == null)", new Object[]{JSON_PARSER_VARIABLE_NAME}).addStatement("$L.nextToken()", new Object[]{JSON_PARSER_VARIABLE_NAME}).endControlFlow().beginControlFlow("if ($L.getCurrentToken() != $T.START_OBJECT)", new Object[]{JSON_PARSER_VARIABLE_NAME, JsonToken.class}).addStatement("$L.skipChildren()", new Object[]{JSON_PARSER_VARIABLE_NAME}).addStatement("return null", new Object[0]).endControlFlow().beginControlFlow("while ($L.nextToken() != $T.END_OBJECT)", new Object[]{JSON_PARSER_VARIABLE_NAME, JsonToken.class}).addStatement("String fieldName = $L.getCurrentName()", new Object[]{JSON_PARSER_VARIABLE_NAME}).addStatement("$L.nextToken()", new Object[]{JSON_PARSER_VARIABLE_NAME}).addStatement("parseField(instance, fieldName, $L)", new Object[]{JSON_PARSER_VARIABLE_NAME}).addStatement("$L.skipChildren()", new Object[]{JSON_PARSER_VARIABLE_NAME}).endControlFlow();
            if (!TextUtils.isEmpty(this.mJsonObjectHolder.onCompleteCallback)) {
                builder.addStatement("instance.$L()", new Object[]{this.mJsonObjectHolder.onCompleteCallback});
            }
            builder.addStatement("return instance", new Object[0]);
        } else {
            builder.addStatement("return null", new Object[0]);
        }
        return builder.build();
    }

    private MethodSpec getParseFieldMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"parseField").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.mJsonObjectHolder.objectTypeName, "instance", new Modifier[0]).addParameter(String.class, "fieldName", new Modifier[0]).addParameter(JsonParser.class, JSON_PARSER_VARIABLE_NAME, new Modifier[0]).addException(IOException.class);
        int parseFieldLines = this.addParseFieldLines(builder);
        if (this.mJsonObjectHolder.hasParentClass()) {
            if (parseFieldLines > 0) {
                builder.nextControlFlow("else", new Object[0]);
                builder.addStatement("$L.parseField(instance, fieldName, $L)", new Object[]{PARENT_OBJECT_MAPPER_VARIABLE_NAME, JSON_PARSER_VARIABLE_NAME});
            } else {
                builder.addStatement("$L.parseField(instance, fieldName, $L)", new Object[]{PARENT_OBJECT_MAPPER_VARIABLE_NAME, JSON_PARSER_VARIABLE_NAME});
            }
        }
        if (parseFieldLines > 0) {
            builder.endControlFlow();
        }
        return builder.build();
    }

    private MethodSpec getSerializeMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"serialize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.mJsonObjectHolder.objectTypeName, "object", new Modifier[0]).addParameter(JsonGenerator.class, JSON_GENERATOR_VARIABLE_NAME, new Modifier[0]).addParameter(Boolean.TYPE, "writeStartAndEnd", new Modifier[0]).addException(IOException.class);
        this.insertSerializeStatements(builder);
        return builder.build();
    }

    private void insertSerializeStatements(MethodSpec.Builder builder) {
        if (!TextUtils.isEmpty(this.mJsonObjectHolder.preSerializeCallback)) {
            builder.addStatement("object.$L()", new Object[]{this.mJsonObjectHolder.preSerializeCallback});
        }
        builder.beginControlFlow("if (writeStartAndEnd)", new Object[0]).addStatement("$L.writeStartObject()", new Object[]{JSON_GENERATOR_VARIABLE_NAME}).endControlFlow();
        ArrayList<String> processedFields = new ArrayList<String>(this.mJsonObjectHolder.fieldMap.size());
        for (Map.Entry<String, JsonFieldHolder> entry : this.mJsonObjectHolder.fieldMap.entrySet()) {
            JsonFieldHolder fieldHolder = entry.getValue();
            if (!fieldHolder.shouldSerialize) continue;
            String getter = fieldHolder.hasGetter() ? "object." + fieldHolder.getterMethod + "()" : "object." + entry.getKey();
            fieldHolder.type.serialize(builder, 1, fieldHolder.fieldName[0], processedFields, getter, true, true, this.mJsonObjectHolder.serializeNullObjects, this.mJsonObjectHolder.serializeNullCollectionElements);
        }
        if (this.mJsonObjectHolder.hasParentClass()) {
            builder.addStatement("$L.serialize(object, $L, false)", new Object[]{PARENT_OBJECT_MAPPER_VARIABLE_NAME, JSON_GENERATOR_VARIABLE_NAME});
        }
        builder.beginControlFlow("if (writeStartAndEnd)", new Object[0]).addStatement("$L.writeEndObject()", new Object[]{JSON_GENERATOR_VARIABLE_NAME}).endControlFlow();
    }

    private int addParseFieldLines(MethodSpec.Builder builder) {
        int entryCount = 0;
        for (Map.Entry<String, JsonFieldHolder> entry : this.mJsonObjectHolder.fieldMap.entrySet()) {
            Object[] stringFormatArgs;
            String setter;
            JsonFieldHolder fieldHolder = entry.getValue();
            if (!fieldHolder.shouldParse) continue;
            ArrayList<String> args = new ArrayList<String>();
            StringBuilder ifStatement = new StringBuilder();
            boolean isFirst = true;
            for (String fieldName : fieldHolder.fieldName) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    ifStatement.append(" || ");
                }
                ifStatement.append("$S.equals(fieldName)");
                args.add(fieldName);
            }
            if (entryCount == 0) {
                builder.beginControlFlow("if (" + ifStatement.toString() + ")", args.toArray(new Object[args.size()]));
            } else {
                builder.nextControlFlow("else if (" + ifStatement.toString() + ")", args.toArray(new Object[args.size()]));
            }
            if (fieldHolder.hasSetter()) {
                setter = "instance.$L($L)";
                stringFormatArgs = new Object[]{fieldHolder.setterMethod};
            } else {
                setter = "instance.$L = $L";
                stringFormatArgs = new Object[]{entry.getKey()};
            }
            if (fieldHolder.type != null) {
                this.setFieldHolderJsonMapperVariableName(fieldHolder.type);
                fieldHolder.type.parse(builder, 1, setter, stringFormatArgs);
            }
            ++entryCount;
        }
        return entryCount;
    }

    private void addUsedJsonMapperVariables(TypeSpec.Builder builder) {
        HashSet<Type.ClassNameObjectMapper> usedJsonObjectMappers = new HashSet<Type.ClassNameObjectMapper>();
        for (JsonFieldHolder holder : this.mJsonObjectHolder.fieldMap.values()) {
            usedJsonObjectMappers.addAll(holder.type.getUsedJsonObjectMappers());
        }
        for (Type.ClassNameObjectMapper usedJsonObjectMapper : usedJsonObjectMappers) {
            builder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JsonMapper.class), (TypeName[])new TypeName[]{usedJsonObjectMapper.className}), (String)ObjectMapperInjector.getMapperVariableName(usedJsonObjectMapper.objectMapper), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$T.mapperFor($T.class)", new Object[]{LoganSquareX.class, usedJsonObjectMapper.className}).build());
        }
    }

    private void addUsedTypeConverterMethods(TypeSpec.Builder builder) {
        HashSet<TypeName> usedTypeConverters = new HashSet<TypeName>();
        for (JsonFieldHolder holder : this.mJsonObjectHolder.fieldMap.values()) {
            usedTypeConverters.addAll(holder.type.getUsedTypeConverters());
        }
        for (TypeName usedTypeConverter : usedTypeConverters) {
            String variableName = ObjectMapperInjector.getTypeConverterVariableName(usedTypeConverter);
            builder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeConverter.class), (TypeName[])new TypeName[]{usedTypeConverter}), (String)variableName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build());
            builder.addMethod(MethodSpec.methodBuilder((String)ObjectMapperInjector.getTypeConverterGetter(usedTypeConverter)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TypeConverter.class), (TypeName[])new TypeName[]{usedTypeConverter})).beginControlFlow("if ($L == null)", new Object[]{variableName}).addStatement("$L = $T.typeConverterFor($T.class)", new Object[]{variableName, LoganSquareX.class, usedTypeConverter}).endControlFlow().addStatement("return $L", new Object[]{variableName}).build());
        }
    }

    private String getJsonMapperVariableNameForTypeParameter(String typeName) {
        String typeNameHash = "" + typeName.hashCode();
        typeNameHash = typeNameHash.replaceAll("-", "m");
        return "m" + typeNameHash + "ClassJsonMapper";
    }

    public static String getStaticFinalTypeConverterVariableName(TypeName typeName) {
        return typeName.toString().replaceAll("\\.", "_").replaceAll("\\$", "_").toUpperCase();
    }

    public static String getTypeConverterVariableName(TypeName typeName) {
        return typeName.toString().replaceAll("\\.", "_").replaceAll("\\$", "_") + "_type_converter";
    }

    private void setFieldHolderJsonMapperVariableName(Type type) {
        if (type instanceof ParameterizedTypeField) {
            ParameterizedTypeField parameterizedType = (ParameterizedTypeField)type;
            parameterizedType.setJsonMapperVariableName(this.getJsonMapperVariableNameForTypeParameter(parameterizedType.getParameterName()));
        }
        for (Type subType : type.parameterTypes) {
            this.setFieldHolderJsonMapperVariableName(subType);
        }
    }

    public static String getMapperVariableName(Class cls) {
        return ObjectMapperInjector.getMapperVariableName(cls.getCanonicalName());
    }

    public static String getMapperVariableName(String fullyQualifiedClassName) {
        return fullyQualifiedClassName.replaceAll("\\.", "_").replaceAll("\\$", "_").toUpperCase();
    }

    public static String getTypeConverterGetter(TypeName typeName) {
        return "get" + ObjectMapperInjector.getTypeConverterVariableName(typeName);
    }
}

