/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.type.field;

import com.squareup.javapoet.MethodSpec;
import io.logansquarex.processor.type.field.FieldType;
import java.util.List;

public abstract class NumberFieldType
extends FieldType {
    protected boolean isPrimitive;

    public NumberFieldType(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public void serialize(MethodSpec.Builder builder, int depth, String fieldName, List<String> processedFieldNames, String getter, boolean isObjectProperty, boolean checkIfNull, boolean writeIfNull, boolean writeCollectionElementIfNull) {
        if (!this.isPrimitive && checkIfNull) {
            builder.beginControlFlow("if ($L != null)", new Object[]{getter});
        }
        if (isObjectProperty) {
            builder.addStatement("$L.writeNumberField($S, $L)", new Object[]{"jsonGenerator", fieldName, getter});
        } else {
            builder.addStatement("$L.writeNumber($L)", new Object[]{"jsonGenerator", getter});
        }
        if (!this.isPrimitive && checkIfNull) {
            if (writeIfNull) {
                builder.nextControlFlow("else", new Object[0]);
                if (isObjectProperty) {
                    builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
                }
                builder.addStatement("$L.writeNull()", new Object[]{"jsonGenerator"});
            }
            builder.endControlFlow();
        }
    }
}

