/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.type.field;

import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import io.logansquarex.processor.type.field.NumberFieldType;

public class LongFieldType
extends NumberFieldType {
    public LongFieldType(boolean isPrimitive) {
        super(isPrimitive);
    }

    @Override
    public TypeName getTypeName() {
        return this.isPrimitive ? TypeName.LONG : ClassName.get(Long.class);
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return ClassName.get(Long.class);
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        if (this.isPrimitive) {
            setter = LongFieldType.replaceLastLiteral(setter, "$L.getValueAsLong()");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
        } else {
            setter = LongFieldType.replaceLastLiteral(setter, "$L.getCurrentToken() == $T.VALUE_NULL ? null : Long.valueOf($L.getValueAsLong())");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser", JsonToken.class, "jsonParser"));
        }
    }
}

