/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.type.collection;

import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.MethodSpec;
import io.logansquarex.processor.processor.TextUtils;
import io.logansquarex.processor.type.Type;
import io.logansquarex.processor.type.collection.CollectionType;
import java.util.List;

public abstract class SingleParameterCollectionType
extends CollectionType {
    public abstract Class getGenericClass();

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        Type parameterType = (Type)this.parameterTypes.get(0);
        String collectionVarName = "collection" + depth;
        String valueVarName = "value" + depth;
        String instanceCreator = String.format("$T<%s> $L = new $T<%s>()", parameterType.getParameterizedTypeString(), parameterType.getParameterizedTypeString());
        Object[] instanceCreatorArgs = this.expandStringArgs(this.getTypeName(), parameterType.getParameterizedTypeStringArgs(), collectionVarName, this.getTypeName(), parameterType.getParameterizedTypeStringArgs());
        builder.beginControlFlow("if ($L.getCurrentToken() == $T.START_ARRAY)", new Object[]{"jsonParser", JsonToken.class}).addStatement(instanceCreator, instanceCreatorArgs).beginControlFlow("while ($L.nextToken() != $T.END_ARRAY)", new Object[]{"jsonParser", JsonToken.class}).addStatement("$T $L", new Object[]{parameterType.getTypeName(), valueVarName});
        parameterType.parse(builder, depth + 1, "$L = $L", valueVarName);
        builder.addStatement("$L.add($L)", new Object[]{collectionVarName, valueVarName}).endControlFlow();
        builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, collectionVarName)).nextControlFlow("else", new Object[0]).addStatement(setter, this.expandStringArgs(setterFormatArgs, "null")).endControlFlow();
    }

    @Override
    public void serialize(MethodSpec.Builder builder, int depth, String fieldName, List<String> processedFieldNames, String getter, boolean isObjectProperty, boolean checkIfNull, boolean writeIfNull, boolean writeCollectionElementIfNull) {
        Type parameterType = (Type)this.parameterTypes.get(0);
        String cleanFieldName = TextUtils.toUniqueFieldNameVariable(fieldName, processedFieldNames);
        String collectionVariableName = "lslocal" + cleanFieldName;
        String elementVarName = "element" + depth;
        String instanceCreator = String.format("final $T<%s> $L = $L", parameterType.getParameterizedTypeString());
        Object[] instanceCreatorArgs = this.expandStringArgs(this.getGenericClass(), parameterType.getParameterizedTypeStringArgs(), collectionVariableName, getter);
        String forLine = String.format("for (%s $L : $L)", parameterType.getParameterizedTypeString());
        Object[] forLineArgs = this.expandStringArgs(parameterType.getParameterizedTypeStringArgs(), elementVarName, collectionVariableName);
        builder.addStatement(instanceCreator, instanceCreatorArgs).beginControlFlow("if ($L != null)", new Object[]{collectionVariableName});
        if (isObjectProperty) {
            builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
        }
        builder.addStatement("$L.writeStartArray()", new Object[]{"jsonGenerator"}).beginControlFlow(forLine, forLineArgs).beginControlFlow("if ($L != null)", new Object[]{elementVarName});
        parameterType.serialize(builder, depth + 1, collectionVariableName + "Element", processedFieldNames, elementVarName, false, false, false, writeCollectionElementIfNull);
        if (writeCollectionElementIfNull) {
            builder.nextControlFlow("else", new Object[0]).addStatement("$L.writeNull()", new Object[]{"jsonGenerator"});
        }
        builder.endControlFlow().endControlFlow().addStatement("$L.writeEndArray()", new Object[]{"jsonGenerator"}).endControlFlow();
    }
}

