/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.processor;

import io.logansquarex.processor.Processor;
import io.logansquarex.processor.processor.JsonMapperLoaderInjector;
import io.logansquarex.processor.processor.JsonObjectHolder;
import io.logansquarex.processor.processor.ObjectMapperInjector;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class JsonAnnotationProcessor
extends AbstractProcessor {
    private Elements mElementUtils;
    private Types mTypeUtils;
    private Filer mFiler;
    private List<Processor> mProcessors;
    private Map<String, JsonObjectHolder> mJsonObjectMap;
    private boolean mLoaderWritten;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.mElementUtils = env.getElementUtils();
        this.mTypeUtils = env.getTypeUtils();
        this.mFiler = env.getFiler();
        this.mJsonObjectMap = new HashMap<String, JsonObjectHolder>();
        this.mProcessors = Processor.allProcessors(this.processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> supportTypes = new LinkedHashSet<String>();
        for (Processor processor : this.mProcessors) {
            supportTypes.add(processor.getAnnotation().getCanonicalName());
        }
        return supportTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        try {
            for (Processor processor : this.mProcessors) {
                processor.findAndParseObjects(env, this.mJsonObjectMap, this.mElementUtils, this.mTypeUtils);
            }
            if (!this.mLoaderWritten) {
                this.mLoaderWritten = true;
                JsonMapperLoaderInjector loaderInjector = new JsonMapperLoaderInjector(this.mJsonObjectMap.values());
                try {
                    JavaFileObject jfo = this.mFiler.createSourceFile("io.logansquarex.JsonMapperLoaderImpl", new Element[0]);
                    Writer writer = jfo.openWriter();
                    writer.write(loaderInjector.getJavaClassFile());
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    this.error("JsonMapperLoaderImpl", "Exception occurred while attempting to write injector for the mapper loader. Exception message: %s", e.getMessage());
                }
            }
            for (Map.Entry<String, JsonObjectHolder> entry : this.mJsonObjectMap.entrySet()) {
                String fqcn = entry.getKey();
                JsonObjectHolder jsonObjectHolder = entry.getValue();
                if (jsonObjectHolder.fileCreated) continue;
                jsonObjectHolder.fileCreated = true;
                try {
                    JavaFileObject jfo = this.mFiler.createSourceFile(fqcn, new Element[0]);
                    Writer writer = jfo.openWriter();
                    writer.write(new ObjectMapperInjector(jsonObjectHolder).getJavaClassFile());
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    this.error(fqcn, "Exception occurred while attempting to write injector for type %s. Exception message: %s", fqcn, e.getMessage());
                }
            }
            return true;
        }
        catch (Throwable e) {
            StringWriter stackTrace = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTrace));
            this.error("Exception while processing Json classes. Stack trace incoming:\n%s", stackTrace.toString());
            return false;
        }
    }

    private void error(String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args));
    }
}

