/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor;

import io.logansquarex.core.annotation.JsonObject;
import io.logansquarex.processor.Processor;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public abstract class MethodProcessor
extends Processor {
    protected MethodProcessor(ProcessingEnvironment processingEnv) {
        super(processingEnv);
    }

    public boolean isCallbackMethodAnnotationValid(Element element, String annotationName) {
        TypeElement enclosingElement = (TypeElement)element.getEnclosingElement();
        if (enclosingElement.getAnnotation(JsonObject.class) == null) {
            this.error(enclosingElement, "%s: @%s methods can only be in classes annotated with @%s.", enclosingElement.getQualifiedName(), annotationName, JsonObject.class.getSimpleName());
            return false;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getParameters().size() > 0) {
            this.error(element, "%s: @%s methods must not take any parameters.", enclosingElement.getQualifiedName(), annotationName);
            return false;
        }
        List<? extends Element> allElements = enclosingElement.getEnclosedElements();
        int methodInstances = 0;
        for (Element element2 : allElements) {
            for (AnnotationMirror annotationMirror : element2.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().toString().equals(annotationName)) continue;
                ++methodInstances;
            }
        }
        if (methodInstances != 1) {
            this.error(element, "%s: There can only be one @%s method per class.", enclosingElement.getQualifiedName(), annotationName);
            return false;
        }
        return true;
    }
}

