/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import io.logansquarex.core.annotation.JsonIgnore;
import io.logansquarex.core.annotation.JsonObject;
import io.logansquarex.processor.Processor;
import io.logansquarex.processor.processor.JsonFieldHolder;
import io.logansquarex.processor.processor.JsonObjectHolder;
import io.logansquarex.processor.processor.TextUtils;
import io.logansquarex.processor.processor.TypeUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class JsonObjectProcessor
extends Processor {
    public JsonObjectProcessor(ProcessingEnvironment processingEnv) {
        super(processingEnv);
    }

    @Override
    public Class getAnnotation() {
        return JsonObject.class;
    }

    @Override
    public void findAndParseObjects(RoundEnvironment env, Map<String, JsonObjectHolder> jsonObjectMap, Elements elements, Types types) {
        for (Element element : env.getElementsAnnotatedWith(JsonObject.class)) {
            try {
                this.processJsonObjectAnnotation(element, jsonObjectMap, elements, types);
            }
            catch (Exception e) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                this.error(element, "Unable to generate injector for %s. Stack trace incoming:\n%s", JsonObject.class, stackTrace.toString());
            }
        }
    }

    private void processJsonObjectAnnotation(Element element, Map<String, JsonObjectHolder> jsonObjectMap, Elements elements, Types types) {
        JsonObjectHolder holder;
        TypeElement typeElement = (TypeElement)element;
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error(element, "%s: %s annotation can't be used on private classes.", typeElement.getQualifiedName(), JsonObject.class.getSimpleName());
        }
        if ((holder = jsonObjectMap.get(TypeUtils.getInjectedFQCN(typeElement, elements))) == null) {
            TypeElement superclassElement;
            String packageName = elements.getPackageOf(typeElement).getQualifiedName().toString();
            String objectClassName = TypeUtils.getSimpleClassName(typeElement, packageName);
            String injectedSimpleClassName = objectClassName + "$$JsonObjectMapper";
            boolean abstractClass = element.getModifiers().contains((Object)Modifier.ABSTRACT);
            List<Object> parentTypeParameters = new ArrayList();
            List<String> parentUsedTypeParameters = new ArrayList<String>();
            ClassName parentClassName = null;
            TypeMirror superclass = typeElement.getSuperclass();
            if (superclass.getKind() != TypeKind.NONE && (superclassElement = (TypeElement)types.asElement(superclass)).getAnnotation(JsonObject.class) != null) {
                String superclassName;
                int indexOfTypeParamStart;
                if (superclassElement.getTypeParameters() != null) {
                    parentTypeParameters = superclassElement.getTypeParameters();
                }
                if ((indexOfTypeParamStart = (superclassName = superclass.toString()).indexOf("<")) > 0) {
                    String typeParams = superclassName.substring(indexOfTypeParamStart + 1, superclassName.length() - 1);
                    parentUsedTypeParameters = Arrays.asList(typeParams.split("\\s*,\\s*"));
                }
            }
            while (superclass.getKind() != TypeKind.NONE) {
                superclassElement = (TypeElement)types.asElement(superclass);
                if (superclassElement.getAnnotation(JsonObject.class) != null) {
                    String superclassPackageName = elements.getPackageOf(superclassElement).getQualifiedName().toString();
                    parentClassName = ClassName.get((String)superclassPackageName, (String)TypeUtils.getSimpleClassName(superclassElement, superclassPackageName), (String[])new String[0]);
                    break;
                }
                superclass = superclassElement.getSuperclass();
            }
            JsonObject annotation = element.getAnnotation(JsonObject.class);
            holder = new JsonObjectHolder.JsonObjectHolderBuilder().setPackageName(packageName).setInjectedClassName(injectedSimpleClassName).setObjectTypeName(TypeName.get((TypeMirror)typeElement.asType())).setIsAbstractClass(abstractClass).setParentTypeName((TypeName)parentClassName).setParentTypeParameters(parentTypeParameters).setParentUsedTypeParameters(parentUsedTypeParameters).setFieldDetectionPolicy(annotation.fieldDetectionPolicy()).setFieldNamingPolicy(annotation.fieldNamingPolicy()).setSerializeNullObjects(annotation.serializeNullObjects()).setSerializeNullCollectionElements(annotation.serializeNullCollectionElements()).setTypeParameters(typeElement.getTypeParameters()).build();
            JsonObject.FieldDetectionPolicy fieldDetectionPolicy = annotation.fieldDetectionPolicy();
            if (fieldDetectionPolicy == JsonObject.FieldDetectionPolicy.NONPRIVATE_FIELDS || fieldDetectionPolicy == JsonObject.FieldDetectionPolicy.NONPRIVATE_FIELDS_AND_ACCESSORS) {
                this.addAllNonPrivateFields(element, elements, types, holder);
            }
            if (fieldDetectionPolicy == JsonObject.FieldDetectionPolicy.NONPRIVATE_FIELDS_AND_ACCESSORS) {
                this.addAllNonPrivateAccessors(element, elements, types, holder);
            }
            jsonObjectMap.put(TypeUtils.getInjectedFQCN(typeElement, elements), holder);
        }
    }

    private void addAllNonPrivateFields(Element element, Elements elements, Types types, JsonObjectHolder objectHolder) {
        List<? extends Element> enclosedElements = element.getEnclosedElements();
        for (Element element2 : enclosedElements) {
            Set<Modifier> modifiers;
            ElementKind enclosedElementKind = element2.getKind();
            if (enclosedElementKind != ElementKind.FIELD || (modifiers = element2.getModifiers()).contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.PROTECTED) || modifiers.contains((Object)Modifier.TRANSIENT) || modifiers.contains((Object)Modifier.STATIC)) continue;
            this.createOrUpdateFieldHolder(element2, elements, types, objectHolder);
        }
    }

    private void addAllNonPrivateAccessors(Element element, Elements elements, Types types, JsonObjectHolder objectHolder) {
        List<? extends Element> enclosedElements = element.getEnclosedElements();
        for (Element element2 : enclosedElements) {
            Set<Modifier> modifiers;
            ElementKind enclosedElementKind = element2.getKind();
            if (enclosedElementKind != ElementKind.FIELD || !(modifiers = element2.getModifiers()).contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.TRANSIENT) || modifiers.contains((Object)Modifier.STATIC)) continue;
            String getter = JsonFieldHolder.getGetter(element2, elements);
            String setter = JsonFieldHolder.getSetter(element2, elements);
            if (TextUtils.isEmpty(getter) || TextUtils.isEmpty(setter)) continue;
            this.createOrUpdateFieldHolder(element2, elements, types, objectHolder);
        }
    }

    private void createOrUpdateFieldHolder(Element element, Elements elements, Types types, JsonObjectHolder objectHolder) {
        boolean shouldSerialize;
        JsonIgnore ignoreAnnotation = element.getAnnotation(JsonIgnore.class);
        boolean shouldParse = ignoreAnnotation == null || ignoreAnnotation.ignorePolicy() == JsonIgnore.IgnorePolicy.SERIALIZE_ONLY;
        boolean bl = shouldSerialize = ignoreAnnotation == null || ignoreAnnotation.ignorePolicy() == JsonIgnore.IgnorePolicy.PARSE_ONLY;
        if (shouldParse || shouldSerialize) {
            String error;
            JsonFieldHolder fieldHolder = objectHolder.fieldMap.get(element.getSimpleName().toString());
            if (fieldHolder == null) {
                fieldHolder = new JsonFieldHolder();
                objectHolder.fieldMap.put(element.getSimpleName().toString(), fieldHolder);
            }
            if (!TextUtils.isEmpty(error = fieldHolder.fill(element, elements, types, null, null, objectHolder, shouldParse, shouldSerialize))) {
                this.error(element, error, new Object[0]);
            }
        }
    }
}

