/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor.type.field;

import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import io.logansquarex.processor.type.field.NumberFieldType;

public class IntegerFieldType
extends NumberFieldType {
    public IntegerFieldType(boolean isPrimitive) {
        super(isPrimitive);
    }

    @Override
    public TypeName getTypeName() {
        return this.isPrimitive ? TypeName.INT : ClassName.get(Integer.class);
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return ClassName.get(Integer.class);
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        if (this.isPrimitive) {
            setter = IntegerFieldType.replaceLastLiteral(setter, "$L.getValueAsInt()");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
        } else {
            setter = IntegerFieldType.replaceLastLiteral(setter, "$L.getCurrentToken() == $T.VALUE_NULL ? null : Integer.valueOf($L.getValueAsInt())");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser", JsonToken.class, "jsonParser"));
        }
    }
}

