/*
 * Decompiled with CFR 0.152.
 */
package io.logansquarex.processor;

import io.logansquarex.processor.JsonFieldProcessor;
import io.logansquarex.processor.JsonObjectProcessor;
import io.logansquarex.processor.OnJsonParseCompleteProcessor;
import io.logansquarex.processor.OnPreSerializeProcessor;
import io.logansquarex.processor.processor.JsonObjectHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public abstract class Processor {
    protected ProcessingEnvironment mProcessingEnv;

    protected Processor(ProcessingEnvironment processingEnv) {
        this.mProcessingEnv = processingEnv;
    }

    public abstract Class getAnnotation();

    public abstract void findAndParseObjects(RoundEnvironment var1, Map<String, JsonObjectHolder> var2, Elements var3, Types var4);

    public static List<Processor> allProcessors(ProcessingEnvironment processingEnvironment) {
        ArrayList<Processor> list = new ArrayList<Processor>();
        list.add(new JsonObjectProcessor(processingEnvironment));
        list.add(new OnJsonParseCompleteProcessor(processingEnvironment));
        list.add(new OnPreSerializeProcessor(processingEnvironment));
        list.add(new JsonFieldProcessor(processingEnvironment));
        return list;
    }

    public void error(Element element, String message, Object ... args) {
        this.mProcessingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
    }
}

