/*
 * Decompiled with CFR 0.152.
 */
package io.loader.jenkins.api;

import io.loader.jenkins.api.SummaryData;
import io.loader.jenkins.api.TestData;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderAPI {
    static final String baseApiUri = "https://api.loader.io/v2/";
    PrintStream logger = new PrintStream(System.out);
    String apiKey;

    public LoaderAPI(String apiKey) {
        this.logger.println("in #LoaderAPI, apiKey: " + apiKey);
        this.apiKey = apiKey;
    }

    public Map<String, String> getTestList() {
        JSONArray list = this.getTests();
        if (list == null) {
            return null;
        }
        HashMap<String, String> tests = new HashMap<String, String>();
        for (Object test : list) {
            JSONObject t = (JSONObject)test;
            String title = this.prepareTestTitle(t);
            tests.put(t.getString("test_id"), title);
        }
        return tests;
    }

    protected String prepareTestTitle(JSONObject test) {
        String id = "";
        try {
            id = test.getString("test_id");
            String title = test.getString("name");
            String domain = test.getString("domain");
            String asTitle = this.isEmptyString(title) ? domain : title;
            return String.format("%s (%s)", asTitle, id);
        }
        catch (RuntimeException ex) {
            this.logger.println("Got Exception: " + ex);
            return id;
        }
    }

    protected boolean isEmptyString(String string) {
        return string == null || string.trim().isEmpty();
    }

    public JSONArray getApps() {
        this.logger.println("in #getApps");
        return this.getListData("apps");
    }

    public JSONArray getTests() {
        this.logger.println("in #getTests");
        return this.getListData("tests?status=active&fields[]=name&fields[]=domain");
    }

    private JSONArray getListData(String path) {
        Result result = this.doGetRequest(path);
        this.logger.println("Result (max 1000 symbols):::" + result.code + "\n" + (result.body.length() > 1000 ? result.body.substring(0, 1000) : result.body));
        if (result.isFail()) {
            return null;
        }
        try {
            JSON list = JSONSerializer.toJSON((Object)result.body);
            if (list.isArray()) {
                return (JSONArray)list;
            }
            return null;
        }
        catch (RuntimeException ex) {
            this.logger.println("Got Exception: " + ex);
            return null;
        }
    }

    public TestData getTest(String testId) {
        this.logger.println("in #getTest");
        Result result = this.doGetRequest("tests/" + testId);
        this.logger.println("Result :::" + result.code + "\n" + result.body);
        if (result.isFail()) {
            return null;
        }
        return this.fetchTestData(result.body);
    }

    private TestData fetchTestData(String data) {
        try {
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)data);
            return new TestData(json);
        }
        catch (RuntimeException ex) {
            this.logger.format("Got exception: %s", ex);
            return null;
        }
    }

    public String runTest(String testId) {
        this.logger.println("in #getTests");
        Result result = this.doPutRequest("tests/" + testId + "/run");
        this.logger.println("Result :::" + result.code + "\n" + result.body);
        if (result.isFail()) {
            return null;
        }
        JSONObject body = (JSONObject)JSONSerializer.toJSON((Object)result.body);
        return body.getString("result_id");
    }

    public SummaryData getTestSummaryData(String testId, String summaryId) {
        this.logger.println("in #getTestSummaryData");
        Result result = this.doGetRequest("tests/" + testId + "/results/" + summaryId);
        this.logger.println("Result :::" + result.code + "\n" + result.body);
        if (result.isFail()) {
            return null;
        }
        JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)result.body);
        return new SummaryData(json);
    }

    public boolean isValidApiKey() {
        if (this.isEmptyString(this.apiKey)) {
            this.logger.println("getTestApi apiKey is empty");
            return false;
        }
        JSONArray apps = this.getApps();
        if (null == apps) {
            this.logger.println("invalid ApiKey");
            return false;
        }
        return true;
    }

    private Result doGetRequest(String path) {
        return this.doRequest((HttpRequestBase)new HttpGet(), path);
    }

    private Result doPutRequest(String path) {
        return this.doRequest((HttpRequestBase)new HttpPut(), path);
    }

    private Result doRequest(HttpRequestBase request, String path) {
        HttpResponse response;
        this.stuffHttpRequest(request, path);
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            response = client.execute((HttpUriRequest)request);
        }
        catch (IOException ex) {
            this.logger.format("Error during remote call to API. Exception received: %s", ex);
            return new Result("Network error during remote call to API");
        }
        return new Result(response);
    }

    private void stuffHttpRequest(HttpRequestBase request, String path) {
        URI fullUri = null;
        try {
            fullUri = new URI(baseApiUri + path);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Incorrect URI format: %s", ex);
        }
        request.setURI(fullUri);
        request.addHeader("Content-Type", "application/json");
        request.addHeader("loaderio-Auth", this.apiKey);
    }

    static class Result {
        public int code;
        public String errorMessage;
        public String body;
        static final String badResponseError = "Bad response from API.";
        static final String formatError = "Invalid error format in response.";

        public Result(String error) {
            this.code = -1;
            this.errorMessage = error;
        }

        public Result(HttpResponse response) {
            this.code = response.getStatusLine().getStatusCode();
            try {
                this.body = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException ex) {
                this.code = -1;
                this.errorMessage = badResponseError;
            }
            if (this.code != 200) {
                this.errorMessage = this.getErrorFromJson(this.body);
            }
        }

        public boolean isOk() {
            return 200 == this.code;
        }

        public boolean isFail() {
            return !this.isOk();
        }

        private String getErrorFromJson(String json) {
            JSON object;
            try {
                object = JSONSerializer.toJSON((Object)json);
            }
            catch (JSONException ex) {
                return formatError;
            }
            if (!(object instanceof JSONObject)) {
                return formatError;
            }
            StringBuilder error = new StringBuilder(badResponseError);
            for (Object message : ((JSONObject)object).getJSONArray("errors")) {
                error.append(message.toString());
            }
            return error.toString();
        }
    }
}

