/*
 * Decompiled with CFR 0.152.
 */
package io.loader.jenkins.impl;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.loader.jenkins.AbstractLoaderioCredential;
import io.loader.jenkins.api.LoaderAPI;
import io.loader.jenkins.impl.Messages;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import net.sf.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class LoaderCredentialImpl
extends AbstractLoaderioCredential {
    private static final long serialVersionUID = 1L;
    private final Secret apiKey;
    private final String description;

    @DataBoundConstructor
    public LoaderCredentialImpl(String apiKey, String description) {
        this.apiKey = Secret.fromString((String)apiKey);
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public String getDisplayName() {
            return Messages.LoaderCredential_DisplayName();
        }

        public ListBoxModel doFillScopeItems() {
            ListBoxModel m = new ListBoxModel();
            m.add(CredentialsScope.GLOBAL.getDisplayName(), CredentialsScope.GLOBAL.toString());
            return m;
        }

        public FormValidation doTestConnection(@QueryParameter(value="apiKey") String apiKey) throws MessagingException, IOException, JSONException, ServletException {
            return this.checkLoaderKey(apiKey);
        }

        public FormValidation doTestExistedConnection(@QueryParameter(value="apiKey") Secret apiKey) throws MessagingException, IOException, JSONException, ServletException {
            return this.checkLoaderKey(apiKey.getPlainText());
        }

        private FormValidation checkLoaderKey(String apiKey) throws JSONException, IOException, ServletException {
            LoaderAPI ldr = new LoaderAPI(apiKey);
            if (ldr.isValidApiKey()) {
                return FormValidation.ok((String)"API Key is Valid.");
            }
            return FormValidation.errorWithMarkup((String)"API Key is Invalid");
        }
    }
}

