/*
 * Decompiled with CFR 0.152.
 */
package io.loader.jenkins;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.loader.jenkins.LoaderBuildAction;
import io.loader.jenkins.LoaderCredential;
import io.loader.jenkins.api.LoaderAPI;
import io.loader.jenkins.api.SummaryData;
import io.loader.jenkins.api.TestData;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class LoaderPublisher
extends Notifier {
    private String apiKey;
    private String testId = "";
    private int errorFailedThreshold = 0;
    private int errorUnstableThreshold = 0;
    private int responseTimeFailedThreshold = 0;
    private int responseTimeUnstableThreshold = 0;
    private PrintStream logger;
    @Extension
    public static final LoaderioPerformancePublisherDescriptor DESCRIPTOR = new LoaderioPerformancePublisherDescriptor();

    @DataBoundConstructor
    public LoaderPublisher(String apiKey, String testId, int errorFailedThreshold, int errorUnstableThreshold, int responseTimeFailedThreshold, int responseTimeUnstableThreshold) {
        this.apiKey = apiKey;
        this.errorFailedThreshold = errorFailedThreshold;
        this.errorUnstableThreshold = errorUnstableThreshold;
        this.responseTimeFailedThreshold = responseTimeFailedThreshold;
        this.responseTimeUnstableThreshold = responseTimeUnstableThreshold;
        this.testId = testId;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        LoaderAPI loaderApi;
        String resTestResultId;
        this.logger = listener.getLogger();
        Result result = this.validateParameters(this.logger);
        if (result != Result.SUCCESS) {
            return true;
        }
        String apiKeyId = StringUtils.defaultIfEmpty((String)this.getApiKey(), (String)this.getDescriptor().getApiKey());
        String apiKey = null;
        for (LoaderCredential c : CredentialsProvider.lookupCredentials(LoaderCredential.class, (Item)build.getProject(), (Authentication)ACL.SYSTEM)) {
            if (!StringUtils.equals((String)apiKeyId, (String)c.getId())) continue;
            apiKey = c.getApiKey().getPlainText();
            break;
        }
        if ((resTestResultId = (loaderApi = new LoaderAPI(apiKey)).runTest(this.getTestId())) == null) {
            this.logInfo("Invalid test information");
            result = Result.NOT_BUILT;
            return false;
        }
        int lastPrint = 0;
        int interval = 5;
        while (true) {
            TestData testInfo;
            if ((testInfo = loaderApi.getTest(this.getTestId())) == null) {
                this.logInfo("API return invalid test information");
                result = Result.NOT_BUILT;
                return false;
            }
            if (!testInfo.status.equalsIgnoreCase("running") && !testInfo.status.equalsIgnoreCase("pending")) break;
            this.logInfo("Waiting for test results " + lastPrint + " sec");
            if (testInfo.duration > 0 && testInfo.duration + 60 < lastPrint) {
                this.logInfo("API doesn't return test results");
                result = Result.NOT_BUILT;
                return false;
            }
            lastPrint += interval;
            Thread.sleep(interval * 1000);
        }
        Thread.sleep(10000L);
        SummaryData testSummaryInfo = loaderApi.getTestSummaryData(this.getTestId(), resTestResultId);
        double thresholdTolerance = 5.0E-5;
        if (this.errorFailedThreshold >= 0 && testSummaryInfo.avgErrorRate - (double)this.errorFailedThreshold > thresholdTolerance) {
            result = Result.FAILURE;
            this.logInfo("Test ended with " + Result.FAILURE + " on error percentage threshold");
        } else if (this.errorUnstableThreshold >= 0 && testSummaryInfo.avgErrorRate - (double)this.errorUnstableThreshold > thresholdTolerance) {
            this.logInfo("Test ended with " + Result.UNSTABLE + " on error percentage threshold");
            result = Result.UNSTABLE;
        }
        if (this.responseTimeFailedThreshold >= 0 && (double)(testSummaryInfo.avgResponseTime - this.responseTimeFailedThreshold) > thresholdTolerance) {
            result = Result.FAILURE;
            this.logInfo("Test ended with " + Result.FAILURE + " on response time threshold");
        } else if (this.responseTimeUnstableThreshold >= 0 && (double)(testSummaryInfo.avgResponseTime - this.responseTimeUnstableThreshold) > thresholdTolerance) {
            result = Result.UNSTABLE;
            this.logInfo("Test ended with " + Result.UNSTABLE + " on response time threshold");
        }
        LoaderBuildAction action = new LoaderBuildAction(build, this.getTestId(), resTestResultId);
        build.getActions().add(action);
        build.setResult(result);
        return true;
    }

    private void logInfo(String str) {
        if (this.logger != null) {
            this.logger.println("loader.io: " + str);
        }
    }

    private Result validateParameters(PrintStream logger) {
        Result result = Result.SUCCESS;
        if (this.errorUnstableThreshold >= 0 && this.errorUnstableThreshold <= 100) {
            this.logInfo("Errors percentage greater than or equal to " + this.errorUnstableThreshold + "% will be considered as " + Result.UNSTABLE.toString().toLowerCase());
        } else {
            this.logInfo("ERROR! percentage should be between 0 to 100");
            result = Result.NOT_BUILT;
        }
        if (this.errorFailedThreshold >= 0 && this.errorFailedThreshold <= 100) {
            this.logInfo("Errors percentage greater than or equal to " + this.errorFailedThreshold + "% will be considered as " + Result.FAILURE.toString().toLowerCase());
        } else {
            this.logInfo("ERROR! percentage should be between 0 to 100");
            result = Result.NOT_BUILT;
        }
        if (this.responseTimeUnstableThreshold >= 0) {
            this.logInfo("Response time greater than or equal to " + this.responseTimeUnstableThreshold + "millis will be considered as " + Result.UNSTABLE.toString().toLowerCase());
        } else {
            logger.println("ERROR! percentage should be greater than or equal to 0");
            result = Result.NOT_BUILT;
        }
        if (this.responseTimeFailedThreshold >= 0) {
            this.logInfo("Response time greater than or equal to " + this.responseTimeFailedThreshold + "millis will be considered as " + Result.FAILURE.toString().toLowerCase());
        } else {
            this.logInfo("ERROR! percentage should be greater than or equal to 0");
            result = Result.NOT_BUILT;
        }
        return result;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getResponseTimeFailedThreshold() {
        return this.responseTimeFailedThreshold;
    }

    public void setResponseTimeFailedThreshold(int responseTimeFailedThreshold) {
        this.responseTimeFailedThreshold = responseTimeFailedThreshold;
    }

    public int getResponseTimeUnstableThreshold() {
        return this.responseTimeUnstableThreshold;
    }

    public void setResponseTimeUnstableThreshold(int responseTimeUnstableThreshold) {
        this.responseTimeUnstableThreshold = responseTimeUnstableThreshold;
    }

    public int getErrorFailedThreshold() {
        return this.errorFailedThreshold;
    }

    public void setErrorFailedThreshold(int errorFailedThreshold) {
        this.errorFailedThreshold = Math.max(0, Math.min(errorFailedThreshold, 100));
    }

    public int getErrorUnstableThreshold() {
        return this.errorUnstableThreshold;
    }

    public void setErrorUnstableThreshold(int errorUnstableThreshold) {
        this.errorUnstableThreshold = Math.max(0, Math.min(errorUnstableThreshold, 100));
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public LoaderioPerformancePublisherDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoaderioPerformancePublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        private String apiKey;

        public LoaderioPerformancePublisherDescriptor() {
            super(LoaderPublisher.class);
            this.load();
        }

        public ListBoxModel doFillTestIdItems(@QueryParameter String apiKey) throws FormValidation {
            if (StringUtils.isBlank((String)apiKey)) {
                apiKey = this.getApiKey();
            }
            Secret apiKeyValue = null;
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            for (LoaderCredential c : CredentialsProvider.lookupCredentials(LoaderCredential.class, (Item)item, (Authentication)ACL.SYSTEM)) {
                if (!StringUtils.equals((String)apiKey, (String)c.getId())) continue;
                apiKeyValue = c.getApiKey();
                break;
            }
            ListBoxModel items = new ListBoxModel();
            if (apiKeyValue == null) {
                items.add("No API Key", "-1");
            } else {
                LoaderAPI lda = new LoaderAPI(apiKeyValue.getPlainText());
                try {
                    Map<String, String> testList = lda.getTestList();
                    if (testList == null) {
                        items.add("Invalid API key ", "-1");
                    } else if (testList.isEmpty()) {
                        items.add("No tests", "-1");
                    } else {
                        for (Map.Entry<String, String> test : testList.entrySet()) {
                            items.add(test.getValue(), test.getKey());
                        }
                    }
                }
                catch (Exception e) {
                    throw FormValidation.error((String)e.getMessage(), (Object[])new Object[]{e});
                }
            }
            return items;
        }

        public ListBoxModel doFillApiKeyItems() {
            List global;
            ListBoxModel items = new ListBoxModel();
            HashSet<String> apiKeys = new HashSet<String>();
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            if (item instanceof Job && !(global = CredentialsProvider.lookupCredentials(LoaderCredential.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM)).isEmpty() && !StringUtils.isEmpty((String)this.getApiKey())) {
                items.add("Default API Key", "");
            }
            for (LoaderCredential c : CredentialsProvider.lookupCredentials(LoaderCredential.class, (Item)item, (Authentication)ACL.SYSTEM)) {
                String id = c.getId();
                if (apiKeys.contains(id)) continue;
                items.add(StringUtils.defaultIfEmpty((String)c.getDescription(), (String)id), id);
                apiKeys.add(id);
            }
            return items;
        }

        public List<LoaderCredential> getCredentials(Object scope) {
            ArrayList<LoaderCredential> result = new ArrayList<LoaderCredential>();
            HashSet<String> apiKeys = new HashSet<String>();
            Item item = scope instanceof Item ? (Item)scope : null;
            for (LoaderCredential c : CredentialsProvider.lookupCredentials(LoaderCredential.class, (Item)item, (Authentication)ACL.SYSTEM)) {
                String id = c.getId();
                if (apiKeys.contains(id)) continue;
                result.add(c);
                apiKeys.add(id);
            }
            return result;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Loader.io";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.apiKey = formData.optString("apiKey");
            this.save();
            return true;
        }

        public String getApiKey() {
            List credentials = CredentialsProvider.lookupCredentials(LoaderCredential.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM);
            if (StringUtils.isBlank((String)this.apiKey) && !credentials.isEmpty()) {
                return ((LoaderCredential)credentials.get(0)).getId();
            }
            if (credentials.size() == 1) {
                return ((LoaderCredential)credentials.get(0)).getId();
            }
            for (LoaderCredential c : credentials) {
                if (!StringUtils.equals((String)c.getId(), (String)this.apiKey)) continue;
                return this.apiKey;
            }
            return "";
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }
    }

    public static final class DescriptorImpl
    extends LoaderioPerformancePublisherDescriptor {
    }
}

