/*
 * Decompiled with CFR 0.152.
 */
package io.lktk;

import io.lktk.JNI;
import io.lktk.NativeBLAKE3Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.scijava.nativelib.NativeLoader;

public class NativeBLAKE3 {
    public static final int KEY_LEN = 32;
    public static final int OUT_LEN = 32;
    public static final int BLOCK_LEN = 64;
    public static final int CHUNK_LEN = 1024;
    public static final int MAX_DEPTH = 54;
    public static final int MAX_SIMD_DEGREE = 16;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private static ThreadLocal<ByteBuffer> nativeByteBuffer = new ThreadLocal();
    private static final boolean enabled;
    private long hasher = -1L;

    public static boolean isEnabled() {
        return enabled;
    }

    public NativeBLAKE3() throws IllegalStateException {
        NativeBLAKE3Util.checkState(enabled);
        long l = JNI.create_hasher();
        NativeBLAKE3Util.checkState(l != 0L);
        this.hasher = l;
    }

    public boolean isValid() {
        return this.hasher != -1L;
    }

    public void close() {
        if (this.isValid()) {
            this.cleanUp();
        }
    }

    public void initDefault() {
        this.r.lock();
        try {
            JNI.blake3_hasher_init(this.getHasher());
        }
        finally {
            this.r.unlock();
        }
    }

    public void initKeyed(byte[] byArray) {
        NativeBLAKE3Util.checkArgument(byArray.length == 32);
        ByteBuffer byteBuffer = nativeByteBuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeByteBuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        this.w.lock();
        try {
            JNI.blake3_hasher_init_keyed(this.getHasher(), byteBuffer);
        }
        finally {
            this.w.unlock();
        }
    }

    public void initDeriveKey(String string) {
        this.r.lock();
        try {
            JNI.blake3_hasher_init_derive_key(this.getHasher(), string);
        }
        finally {
            this.r.unlock();
        }
    }

    public void update(byte[] byArray) {
        ByteBuffer byteBuffer = nativeByteBuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
            byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeByteBuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        byteBuffer.put(byArray);
        this.w.lock();
        try {
            JNI.blake3_hasher_update(this.getHasher(), byteBuffer, byArray.length);
        }
        finally {
            this.w.unlock();
        }
    }

    public byte[] getOutput() throws NativeBLAKE3Util.InvalidNativeOutput {
        return this.getOutput(32);
    }

    public byte[] getOutput(int n) throws NativeBLAKE3Util.InvalidNativeOutput {
        ByteBuffer byteBuffer = nativeByteBuffer.get();
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocateDirect(n);
            byteBuffer.order(ByteOrder.nativeOrder());
            nativeByteBuffer.set(byteBuffer);
        }
        byteBuffer.rewind();
        this.w.lock();
        try {
            JNI.blake3_hasher_finalize(this.getHasher(), byteBuffer, n);
        }
        finally {
            this.w.unlock();
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        NativeBLAKE3Util.checkOutput(byArray.length == n, "Output size produced by lib doesnt match:" + byArray.length + " expected:" + n);
        return byArray;
    }

    private long getHasher() throws IllegalStateException {
        NativeBLAKE3Util.checkState(this.isValid());
        return this.hasher;
    }

    private void cleanUp() {
        this.w.lock();
        try {
            JNI.destroy_hasher(this.getHasher());
        }
        finally {
            this.hasher = -1L;
            this.w.unlock();
        }
    }

    static {
        boolean bl = false;
        try {
            NativeLoader.loadLibrary((String)"blake3", (String[])new String[0]);
            bl = true;
        }
        catch (IOException iOException) {
            System.out.println("UnsatisfiedLinkError: " + iOException.toString());
        }
        finally {
            enabled = bl;
        }
    }
}

