/*
 * Decompiled with CFR 0.152.
 */
package io.lippia.api.utils;

import com.crowdar.core.PropertyManager;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.log4j.Logger;

public class XmlUtils {
    private static XmlMapper mapper;

    private static XmlMapper getMapper() {
        if (mapper == null) {
            mapper = new XmlMapper();
        }
        return mapper;
    }

    public static <T> T deserialize(String xml, Class<T> type) {
        try {
            TypeFactory typeFactory = XmlUtils.getMapper().getTypeFactory();
            return (T)XmlUtils.getMapper().readValue(xml, typeFactory.constructType(type));
        }
        catch (IOException e) {
            Logger.getLogger(XmlUtils.class).error((Object)e.getMessage());
            return null;
        }
    }

    public static String serialize(Object xml) {
        String jsonResult = null;
        try {
            jsonResult = XmlUtils.getMapper().writeValueAsString(xml);
        }
        catch (IOException e) {
            Logger.getLogger(XmlUtils.class).error((Object)e.getMessage());
        }
        return jsonResult;
    }

    public static String getXMLFromFile(String fileName) throws IOException {
        String path = System.getProperty("user.dir").concat(File.separator).concat("src").concat(File.separator).concat("test").concat(File.separator).concat("resources").concat(File.separator).concat("xmls").concat(File.separator).concat(fileName).concat(".xml");
        return XmlUtils.getXMLFromPath(path);
    }

    public static String getXMLFromPath(String path) throws IOException {
        return XmlUtils.getXML(Paths.get(path, new String[0]));
    }

    public static <T> T getXMLFromFileAsObject(String file, Class<T> valueType) throws IOException {
        String xml = XmlUtils.getXMLFromFile(file);
        return (T)XmlUtils.getMapper().readValue(xml, valueType);
    }

    public static <T> List<T> getListXMLFromFileAsObject(String file, Class<T> valueType) throws IOException {
        TypeFactory typeFactory = XmlUtils.getMapper().getTypeFactory();
        String xml = XmlUtils.getXMLFromFile(file);
        return (List)XmlUtils.getMapper().readValue(xml, (JavaType)typeFactory.constructCollectionType(List.class, valueType));
    }

    public static String getXML(Path file) throws IOException {
        FileInputStream fis = new FileInputStream(file.toFile());
        JsonNode rootNode = XmlUtils.getMapper().readTree((InputStream)fis);
        return rootNode.toString();
    }

    public static String replaceVarsFromPropertyManager(String xmlUnparsed) throws IOException {
        Handlebars handlebars = new Handlebars();
        Template template = handlebars.compileInline(xmlUnparsed);
        List vars = template.collect(new TagType[]{TagType.VAR});
        for (String var : vars) {
            xmlUnparsed = xmlUnparsed.replace("{{" + var + "}}", PropertyManager.getProperty(var));
        }
        return xmlUnparsed;
    }
}

