/*
 * Decompiled with CFR 0.152.
 */
package io.lippia.api.configuration;

import io.lippia.api.configuration.HttpConfiguration;
import io.lippia.api.service.MethodServiceEnum;
import java.util.HashMap;
import java.util.Map;

public class EndpointConfiguration {
    private static ThreadLocal<EndpointConfiguration> INSTANCE = new ThreadLocal();
    private HttpConfiguration httpConfiguration;
    private Map<String, String> urlParameters;
    private Map<String, String> headers;
    private String body;
    private String tokenPath;
    private MethodServiceEnum methodService;

    public MethodServiceEnum getMethodService() {
        if (this.methodService == null) {
            return MethodServiceEnum.DEFAULT;
        }
        return this.methodService;
    }

    public void setMethodService(MethodServiceEnum methodService) {
        this.methodService = methodService;
    }

    public String getTokenPath() {
        return this.tokenPath;
    }

    public void setTokenPath(String tokenPath) {
        this.tokenPath = tokenPath;
    }

    private EndpointConfiguration() {
    }

    public HttpConfiguration getHttConfiguration() {
        if (this.httpConfiguration == null) {
            this.httpConfiguration = new HttpConfiguration();
        }
        return this.httpConfiguration;
    }

    public Map<String, String> getUrlParameters() {
        if (this.urlParameters == null) {
            this.urlParameters = new HashMap<String, String>();
        }
        return this.urlParameters;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    private void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public static EndpointConfiguration getInstance() {
        if (INSTANCE.get() == null) {
            INSTANCE.set(new EndpointConfiguration());
        }
        return INSTANCE.get();
    }

    public static EndpointConfiguration clean() {
        INSTANCE.set(null);
        return INSTANCE.get();
    }

    public static EndpointConfiguration url(String url) {
        EndpointConfiguration.getInstance().getHttConfiguration().setUrl(url);
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration endpoint(String endpoint) {
        EndpointConfiguration.getInstance().getHttConfiguration().setEndpoint(endpoint);
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration protocol(String protocol) {
        EndpointConfiguration.getInstance().getHttConfiguration().setProtocol(protocol);
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration method(String method) {
        EndpointConfiguration.getInstance().getHttConfiguration().setMethod(method);
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration port(String port) {
        EndpointConfiguration.getInstance().getHttConfiguration().setPort(port);
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration urlParameter(String key, String value) {
        EndpointConfiguration.getInstance().getUrlParameters().put(key, value);
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration body(String body) {
        EndpointConfiguration.getInstance().setBody(body);
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration header(String key, String value) {
        EndpointConfiguration.getInstance().getHeaders().put(key, value);
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration replaceOnBody(String key, String value) {
        EndpointConfiguration.getInstance().setBody(EndpointConfiguration.getInstance().getBody().replace("{{" + key + "}}", value));
        return EndpointConfiguration.getInstance();
    }

    public static EndpointConfiguration methodService(MethodServiceEnum methodServiceEnum) {
        EndpointConfiguration.getInstance().setMethodService(methodServiceEnum);
        return EndpointConfiguration.getInstance();
    }
}

