/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.util;

import com.crowdar.util.FileUtils;
import com.crowdar.util.MapUtils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.testng.Assert;

public class ValidateUtils {
    private static final String GETTER_NAME = "get";
    private static final String SORT_NAME_METHOD = "sort";
    private static final String ERROR_LIST_SIZES = "Size of the lists is not the same.";
    private static final String ERROR_INVALID_KEY = "%s field is invalid. Class: %s";
    private static final String ERROR_INVALID_FORMAT = "%s format is invalid. Class: %s";
    private static final String ERROR_METHOD_NOT_FOUND = "Method %s was not found in: %s";
    private static String methodName;

    private static String getMethodName() {
        return methodName;
    }

    private static void setMethodName(String methodName) {
        ValidateUtils.methodName = methodName;
    }

    public static <T> void validateFields(List<T> actualList, List<T> expectedList) throws Exception {
        Class<?> expectedClass = expectedList.iterator().next().getClass();
        Class<?> actualClass = actualList.iterator().next().getClass();
        ValidateUtils.sort(expectedList, expectedClass);
        ValidateUtils.sort(actualList, actualClass);
        FileUtils.writeListOutputs(actualList, expectedList);
        Assert.assertEquals((int)actualList.size(), (int)expectedList.size(), (String)ERROR_LIST_SIZES);
        ValidateUtils.validateListFields(actualList, expectedList);
    }

    private static <T> void sort(List<T> expectedList, Class expectedClass) throws IllegalAccessException, InvocationTargetException {
        try {
            expectedClass.getMethod(SORT_NAME_METHOD, List.class).invoke((Object)"", expectedList);
        }
        catch (NoSuchMethodException e) {
            Logger.getLogger(ValidateUtils.class).warn((Object)">>> 'sort' method was not found in ".concat(expectedClass.toGenericString()).concat(". Proceeding without sorting the list."));
        }
    }

    private static <T> void validateListFields(List<T> actualList, List<T> expectedList) throws Exception {
        int counter = 0;
        for (T expected : expectedList) {
            Map<String, Object> expectedMap = MapUtils.convertObjectToMap(expected);
            T actual = actualList.get(counter);
            ValidateUtils.validateFields(expectedMap, actual);
            ++counter;
        }
    }

    public static void validateFields(Object expected, Object actual) throws Exception {
        Iterator<Map.Entry> expectedItr = MapUtils.getIterator(MapUtils.convertObjectToMap(expected));
        Class<?> actualClass = actual.getClass();
        while (expectedItr.hasNext()) {
            Map.Entry entry = expectedItr.next();
            String expectedKey = (String)entry.getKey();
            Object expectedValue = entry.getValue();
            ValidateUtils.setMethodName(GETTER_NAME.concat(ValidateUtils.getBasicKey(expectedKey)));
            Object actualValue = ValidateUtils.tryGetMethodValue(actual, actualClass, expectedKey);
            boolean isModel = ValidateUtils.isModelClass(actualValue);
            boolean isListModel = ValidateUtils.isListModelClass(actualValue);
            ValidateUtils.validateFieldsWhileModelList(expectedValue, actualValue, isListModel);
            ValidateUtils.validateFieldsWhileModel(expectedValue, actualValue, isModel);
            if (isModel || isListModel) continue;
            ValidateUtils.doAssertions(actualClass, expectedKey, expectedValue, actualValue);
        }
    }

    private static void doAssertions(Class actualClass, String expectedKey, Object expectedValue, Object actualValue) {
        if (expectedValue != null && actualValue != null) {
            Assert.assertEquals(actualValue.getClass(), expectedValue.getClass(), (String)String.format(ERROR_INVALID_FORMAT, expectedKey.toUpperCase(), actualClass.getSimpleName()));
        }
        Assert.assertEquals((Object)actualValue, (Object)expectedValue, (String)String.format(ERROR_INVALID_KEY, expectedKey.toUpperCase(), actualClass.getSimpleName()));
    }

    private static void validateFieldsWhileModel(Object expectedValue, Object actualValue, boolean isModel) throws Exception {
        if (isModel) {
            ValidateUtils.validateFields(expectedValue, actualValue);
        }
    }

    private static void validateFieldsWhileModelList(Object expectedValue, Object actualValue, boolean isListModel) throws Exception {
        block0: {
            if (!isListModel) break block0;
            List actualList = (List)actualValue;
            List expectedList = (List)expectedValue;
            ValidateUtils.validateFields(actualList, expectedList);
        }
    }

    private static boolean isModelClass(Object object) {
        return object != null && !(object instanceof String) && !(object instanceof Integer) && !(object instanceof Double) && !(object instanceof Boolean) && !(object instanceof Map) && !(object instanceof Float) && !(object instanceof BigDecimal) && !(object instanceof List);
    }

    private static boolean isListModelClass(Object object) {
        if (object instanceof List) {
            List objects = (List)object;
            return ValidateUtils.isModelClass(objects.iterator().next());
        }
        return false;
    }

    private static Object tryGetMethodValue(Object actual, Class actualClass, String expectedKey) throws IllegalAccessException, InvocationTargetException {
        try {
            return ValidateUtils.getMethodValue(actual, actualClass, ValidateUtils.getMethodName());
        }
        catch (NoSuchMethodException e) {
            Logger.getLogger(ValidateUtils.class).warn((Object)">>> Method ".concat(ValidateUtils.getMethodName()).concat(" was not found. Trying with capitalize."));
            ValidateUtils.setMethodName(GETTER_NAME.concat(ValidateUtils.getFullKey(expectedKey)));
            return ValidateUtils.tryWithCapitalizeAndReplace(actual, actualClass);
        }
    }

    private static Object tryWithCapitalizeAndReplace(Object actual, Class actualClass) throws IllegalAccessException, InvocationTargetException {
        Object value = null;
        try {
            value = ValidateUtils.getMethodValue(actual, actualClass, ValidateUtils.getMethodName());
        }
        catch (NoSuchMethodException e1) {
            Assert.assertTrue((boolean)false, (String)String.format(ERROR_METHOD_NOT_FOUND, ValidateUtils.getMethodName(), actualClass.toGenericString()));
        }
        return value;
    }

    private static String getFullKey(String expectedKey) {
        return WordUtils.capitalizeFully((String)expectedKey, (char[])new char[]{' ', '_', '.'}).replaceAll("\\s", "").replaceAll("_", "").replaceAll("\\.", "");
    }

    private static String getBasicKey(String expectedKey) {
        return WordUtils.capitalize((String)expectedKey).replaceAll("\\s", "");
    }

    private static Object getMethodValue(Object actual, Class actualClass, String methodName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return actualClass.getMethod(methodName, new Class[0]).invoke(actual, new Object[0]);
    }
}

