/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.util;

import com.crowdar.core.MyThreadLocal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ObjectManager {
    private static final String OBJECTS = "ObjectManager.Objects";

    private static <T> List<T> getObjects() {
        ArrayList querysResult = (ArrayList)MyThreadLocal.getData(OBJECTS);
        if (querysResult == null) {
            querysResult = new ArrayList();
            MyThreadLocal.setData(OBJECTS, querysResult);
        }
        return querysResult;
    }

    public static Object getObject(int position) {
        return ObjectManager.getObjects().get(position);
    }

    public static Object getObject(Class object) {
        return ObjectManager.getObjects().stream().filter(query -> query.getClass().equals(object)).findFirst().orElse(null);
    }

    public static List<Object> getObjects(Class object) {
        return ObjectManager.getObjects().stream().filter(query -> query.getClass().equals(object)).collect(Collectors.toList());
    }

    public static void addObject(Object object) {
        ObjectManager.getObjects().add(object);
    }

    public static void cleanObjects() {
        MyThreadLocal.setData(OBJECTS, null);
    }
}

