/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.util;

import com.crowdar.util.DateUtils;
import com.crowdar.util.MapUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class FileUtils {
    private static String tempDirectoryPath = null;
    private static final String fileFormat = "files/%s.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDirPath(String dirName) {
        ZipFile jarFile = null;
        if (tempDirectoryPath == null) {
            tempDirectoryPath = Files.createTempDir().getAbsolutePath();
        }
        if (!new File(tempDirectoryPath + File.separator + dirName.replaceAll("/", "")).exists()) {
            try {
                ArrayList<JarEntry> dirEntries = new ArrayList<JarEntry>();
                File directory = null;
                String jarFileName = new File(FileUtils.class.getClassLoader().getResource(dirName).getPath()).getParent().replaceAll("(!|file:\\\\)", "").replaceAll("(!|file:)", "");
                jarFile = new JarFile(URLDecoder.decode(jarFileName, "UTF-8"));
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    if (!jarEntry.getName().startsWith(dirName)) continue;
                    if (jarEntry.getName().replaceAll("/", "").equals(dirName.replaceAll("/", ""))) {
                        directory = new File(tempDirectoryPath + File.separator + dirName.replaceAll("/", ""));
                        directory.mkdirs();
                        continue;
                    }
                    dirEntries.add(jarEntry);
                }
                if (directory == null) {
                    throw new RuntimeException("There is no directory " + dirName + "in the jar file");
                }
                for (JarEntry dirEntry : dirEntries) {
                    File dirFile;
                    if (!dirEntry.isDirectory()) {
                        dirFile = new File(directory.getParent() + File.separator + dirEntry.getName());
                        dirFile.createNewFile();
                        FileUtils.convertStreamToFile(dirEntry.getName(), dirFile);
                        continue;
                    }
                    dirFile = new File(directory.getParent() + File.separator + dirEntry.getName());
                    dirFile.mkdirs();
                }
                String string = directory.getAbsolutePath();
                return string;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            throw new RuntimeException("There are problems in creation files in directory " + tempDirectoryPath);
        }
        return tempDirectoryPath + File.separator + dirName.replaceAll("/", "");
    }

    private static void convertStreamToFile(String resourceFileName, File file) throws IOException {
        String line;
        InputStream in = FileUtils.class.getClassLoader().getResourceAsStream(resourceFileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
        BufferedWriter fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        while ((line = reader.readLine()) != null) {
            fileWriter.write(line + "\n");
        }
        fileWriter.flush();
        fileWriter.close();
        in.close();
    }

    public static boolean platformIsWindows() {
        return File.separatorChar == '\\';
    }

    public static void writeToJson(String jsonFilePath, Object object) {
        try {
            Gson gson = new Gson();
            FileWriter fileWriter = new FileWriter(jsonFilePath);
            fileWriter.write(gson.toJson(object));
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> readLines(File f, String encoding) {
        try {
            return org.apache.commons.io.FileUtils.readLines((File)f, (String)encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLines(File f, String encoding, List<String> lines) {
        try {
            org.apache.commons.io.FileUtils.writeLines((File)f, (String)encoding, lines);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void modifyLine(List<String> lines, int line, String replacement) {
        lines.set(line, replacement);
    }

    public static List<Object> jsonReader(String fileName) {
        try {
            List<Object> users;
            ObjectMapper objectMapper = new ObjectMapper();
            fileName = String.format(fileFormat, fileName);
            try {
                users = (List)objectMapper.readValue(new File(fileName), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, Object.class));
            }
            catch (EOFException e) {
                users = new ArrayList<Object>();
            }
            catch (FileNotFoundException e) {
                users = new ArrayList();
                File f = new File(fileName);
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            return users;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getValueFromJsonFile(String fileName) {
        LinkedList queue = FileUtils.jsonReader(fileName).stream().map(Object::toString).collect(Collectors.toCollection(LinkedList::new));
        String value = (String)queue.remove();
        return value;
    }

    public static <T> void writeListOutputs(List<T> actualList, List<T> expectedList) {
        try {
            String className = FileUtils.getClassName(actualList);
            String random = DateUtils.getActualDateFormatted("ddmmyyHHmm-ss-SSS");
            FileUtils.writeOutput(actualList, random, "actual".concat(className));
            FileUtils.writeOutput(expectedList, random, "expected".concat(className));
        }
        catch (Exception e) {
            Logger.getLogger(FileUtils.class).error((Object)">>> Error trying to write the output: ", (Throwable)e);
        }
    }

    private static <T> void writeOutput(List<T> list, String random, String fileInitialName) throws IOException {
        FileWriter writer = FileUtils.getFileWriter(random, fileInitialName.concat("_"));
        ArrayList<String> headers = new ArrayList<String>();
        Boolean headersAdded = false;
        for (T object : list) {
            ArrayList<String> outputs = new ArrayList<String>();
            TreeMap<String, Object> sorted = MapUtils.sortMap(object);
            FileUtils.addData(headers, headersAdded, outputs, sorted);
            headersAdded = FileUtils.writeDataInFile(writer, headers, headersAdded, outputs);
        }
        writer.close();
    }

    private static Boolean writeDataInFile(FileWriter writer, List<String> headers, Boolean headersAdded, List<String> outputs) throws IOException {
        if (!headersAdded.booleanValue()) {
            String headerActual = String.join((CharSequence)",", headers);
            writer.write(headerActual.concat(System.lineSeparator()));
        }
        String output = String.join((CharSequence)",", outputs);
        writer.write(output.concat(System.lineSeparator()));
        return true;
    }

    private static void addData(List<String> headers, Boolean headersAdded, List<String> outputs, Map<String, Object> sorted) {
        Iterator<Map.Entry> iterator = MapUtils.getIterator(sorted);
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            outputs.add(String.valueOf(value));
            if (headersAdded.booleanValue()) continue;
            headers.add(key.toUpperCase());
        }
    }

    private static <T> String getClassName(List<T> list) {
        return list.iterator().next().getClass().getSimpleName();
    }

    private static FileWriter getFileWriter(String random, String fileName) throws IOException {
        File file = new File(System.getProperty("user.dir").concat(File.separator).concat("target").concat(File.separator).concat("output"));
        file.mkdir();
        return new FileWriter(file.getAbsolutePath().concat(File.separator).concat(fileName + random + ".txt"));
    }
}

