/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.util;

import com.crowdar.core.PropertyManager;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseUtils {
    private static Connection getConnection(String database) throws SQLException {
        return DriverManager.getConnection(PropertyManager.getProperty("db.connection.string") + database, PropertyManager.getProperty("db.connection.user"), PropertyManager.getProperty("db.connection.pass"));
    }

    public static List<Map<String, Object>> executeQuery(String databaseName, String queryString) throws SQLException {
        ArrayList records = null;
        ResultSet rs = null;
        try (Statement st = DatabaseUtils.getConnection(databaseName).createStatement();){
            rs = st.executeQuery(queryString);
            if (rs != null) {
                ResultSetMetaData md = rs.getMetaData();
                int columns = md.getColumnCount();
                records = new ArrayList(columns);
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>(columns);
                    for (int i = 1; i <= columns; ++i) {
                        row.put(md.getColumnName(i), rs.getObject(i));
                    }
                    records.add(row);
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DatabaseUtils.getConnection(databaseName).close();
        }
        return records;
    }

    public static String uniqueResult(String databaseName, String queryString) throws SQLException {
        ResultSet rs = null;
        try {
            String string;
            block15: {
                Statement st = DatabaseUtils.getConnection(databaseName).createStatement();
                try {
                    rs = st.executeQuery(queryString);
                    rs.next();
                    string = rs.getObject(1).toString();
                    if (st == null) break block15;
                }
                catch (Throwable throwable) {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st.close();
            }
            return string;
        }
        finally {
            DatabaseUtils.getConnection(databaseName).close();
        }
    }

    public static boolean executeUpdate(String databaseName, String ddlString) throws SQLException {
        int recAffected = 0;
        try (Statement st = DatabaseUtils.getConnection(databaseName).createStatement();){
            recAffected = st.executeUpdate(ddlString);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            DatabaseUtils.getConnection(databaseName).close();
        }
        return recAffected > 0;
    }
}

