/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.email;

import com.crowdar.core.PropertyManager;
import com.crowdar.email.EmailPropertiesEnum;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.SearchTerm;
import org.jsoup.Jsoup;

public class EmailService {
    private static final String DEFAULT_EMAIL_FOLDER = "INBOX";
    private static Session session;
    private static final Pattern urlPattern;

    private static Properties getProperties() {
        Properties properties = new Properties();
        EmailPropertiesEnum emailPropertiesEnum = EmailPropertiesEnum.get(PropertyManager.getProperty("email.protocol").toUpperCase());
        return emailPropertiesEnum.getProperties(properties);
    }

    public static void sendReportEmail() {
        String from = PropertyManager.getProperty("report.mail.from");
        String to = PropertyManager.getProperty("report.mail.to");
        String cc = PropertyManager.getProperty("report.mail.cc");
        String subject = PropertyManager.getProperty("report.mail.subject");
        try {
            System.out.println("Sending Email...");
            Session session = Session.getDefaultInstance((Properties)EmailService.getProperties());
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from, from));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
            message.setSubject(subject, "UTF-8");
            message.setSentDate(new Date());
            System.out.println("Recipients: " + message.getAllRecipients());
            String reportLink = System.getProperty("crowdar.email.report.public.url");
            message.setText("Report link: \n" + reportLink, "UTF-8");
            Transport.send((Message)message);
            System.out.println("Email Sent Successfully!!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message[] getMessages(String folderParam, String email, String password, final String subject) throws MessagingException {
        Store store = EmailService.getConnection(email, password);
        try {
            Folder folder = store.getFolder(folderParam);
            if (!folder.exists()) {
                throw new MessagingException("The folder DO NOT EXIST in email address");
            }
            folder.open(1);
            SearchTerm bySubject = new SearchTerm(){

                public boolean match(Message m) {
                    try {
                        return m.getSubject().equals(subject);
                    }
                    catch (MessagingException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            Message[] messageArray = folder.search(bySubject);
            return messageArray;
        }
        finally {
            session.getTransport().close();
        }
    }

    public static void downloadAttachmentFile(String subject, String pathToDownload) throws MessagingException, IOException {
        Message[] messages = EmailService.getMessages(DEFAULT_EMAIL_FOLDER, PropertyManager.getProperty("email.user"), PropertyManager.getProperty("email.password"), subject);
        Multipart multiPart = (Multipart)messages[0].getContent();
        for (int i = 0; i < multiPart.getCount(); ++i) {
            MimeBodyPart part = (MimeBodyPart)multiPart.getBodyPart(i);
            if (!"attachment".equalsIgnoreCase(part.getDisposition())) continue;
            part.saveFile(pathToDownload + File.separator + part.getFileName());
        }
    }

    public static void downloadAttachmentFile(String subject) throws MessagingException, IOException {
        File folderPath = Paths.get("target", "downloads").toFile();
        if (!folderPath.exists()) {
            folderPath.mkdir();
        }
        EmailService.downloadAttachmentFile(subject, folderPath.toString());
    }

    public static boolean verifyEmailIsPresent(String email, String password, String subject, String from, String folder) throws MessagingException {
        Message[] messages = EmailService.getMessages(folder, email, password, subject);
        if (messages == null || messages.length == 0) {
            return false;
        }
        for (Message m : messages) {
            String mfrom = m.getFrom()[0].toString();
            String msubject = m.getSubject();
            if (from.isEmpty()) {
                from = mfrom;
            }
            if (!mfrom.contains(from) || !msubject.contains(subject)) continue;
            return true;
        }
        return false;
    }

    public static boolean verifyEmailIsPresent(String email, String password, String subject, String from) throws MessagingException {
        return EmailService.verifyEmailIsPresent(email, password, subject, from, DEFAULT_EMAIL_FOLDER);
    }

    public static boolean verifyEmailIsPresent(String email, String password, String subject) throws MessagingException {
        return EmailService.verifyEmailIsPresent(email, password, subject, "", DEFAULT_EMAIL_FOLDER);
    }

    public static List<String> getLinksFromEmail(String folder, String email, String password, String subject) throws MessagingException {
        ArrayList<String> links = new ArrayList<String>();
        Message[] messages = EmailService.getMessages(folder, email, password, subject);
        if (messages == null || messages.length == 0) {
            return null;
        }
        ArrayList<Message> messageList = new ArrayList<Message>();
        messageList.add(messages[messages.length - 1]);
        for (Message m : messageList) {
            try {
                Object content = m.getContent();
                String mailBody = "";
                if (content instanceof String) {
                    mailBody = (String)content;
                } else if (content instanceof Multipart) {
                    MimeMultipart mimeMultipart = (MimeMultipart)m.getContent();
                    mailBody = EmailService.getTextFromMimeMultipart(mimeMultipart);
                }
                Matcher matcher = urlPattern.matcher(mailBody);
                while (matcher.find()) {
                    int matchStart = matcher.start(1);
                    int matchEnd = matcher.end();
                    String urlResetPassword = mailBody.substring(matchStart, matchEnd);
                    links.add(urlResetPassword);
                }
            }
            catch (Exception e) {
                throw new MessagingException(e.getMessage());
            }
        }
        return links;
    }

    public static List<String> getLinksFromEmail(String email, String password, String subject) throws MessagingException {
        return EmailService.getLinksFromEmail(DEFAULT_EMAIL_FOLDER, email, password, subject);
    }

    public static String getSMSFromEmail(String folder, String email, String password, String subject) throws MessagingException {
        String sms;
        Message[] messages = EmailService.getMessages(folder, email, password, subject);
        if (messages == null || messages.length == 0) {
            return null;
        }
        Message message = messages[messages.length - 1];
        Pattern pattern = Pattern.compile("\\b(?=\\w)\\d+");
        try {
            Object content = message.getContent();
            String mailBody = (String)content;
            Matcher m = pattern.matcher(mailBody);
            m.find();
            sms = m.group(0);
        }
        catch (Exception e) {
            throw new MessagingException(e.getMessage());
        }
        return sms;
    }

    public static String getSMSFromEmail(String email, String password, String subject) throws MessagingException {
        return EmailService.getSMSFromEmail(DEFAULT_EMAIL_FOLDER, email, password, subject);
    }

    private static String getTextFromMimeMultipart(MimeMultipart mimeMultipart) throws MessagingException, IOException {
        StringBuilder result = new StringBuilder();
        int count = mimeMultipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            if (bodyPart.isMimeType("text/plain")) {
                result.append("\n").append(bodyPart.getContent());
                break;
            }
            if (bodyPart.isMimeType("text/html")) {
                String html = (String)bodyPart.getContent();
                result.append("\n").append(Jsoup.parse((String)html).text());
                continue;
            }
            if (!(bodyPart.getContent() instanceof MimeMultipart)) continue;
            result.append(EmailService.getTextFromMimeMultipart((MimeMultipart)bodyPart.getContent()));
        }
        return result.toString();
    }

    private static Store getConnection(String email, String password) throws MessagingException {
        session = Session.getDefaultInstance((Properties)EmailService.getProperties(), null);
        String protocol = PropertyManager.getProperty("email.protocol");
        Store store = session.getStore(protocol);
        store.connect(session.getProperty("mail.".concat(protocol).concat(".host")), Integer.parseInt(session.getProperty("mail.".concat(protocol).concat(".port"))), email, password);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMailContent(String email, String password, final String subject, String folder) throws MessagingException, IOException, ArrayIndexOutOfBoundsException {
        Store store = EmailService.getConnection(email, password);
        try {
            Folder inbox = store.getFolder(folder);
            inbox.open(1);
            SearchTerm bySubject = new SearchTerm(){

                public boolean match(Message m) {
                    try {
                        return m.getSubject().equals(subject);
                    }
                    catch (MessagingException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            Message[] messages = inbox.search(bySubject);
            Object firstMessage = messages[0].getContent();
            if (firstMessage instanceof Multipart) {
                String string = EmailService.getTextFromMimeMultipart((MimeMultipart)messages[0].getContent());
                return string;
            }
            String string = firstMessage.toString();
            return string;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String string = "Email was not found";
            return string;
        }
        finally {
            session.getTransport().close();
        }
    }

    public static String getMailContent(String email, String password, String subject) throws IOException, MessagingException {
        return EmailService.getMailContent(email, password, subject, DEFAULT_EMAIL_FOLDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllMessages(String folderParam, String email, String password) throws MessagingException {
        Store store = EmailService.getConnection(email, password);
        try {
            Message[] messages;
            Folder folder = store.getFolder(folderParam);
            if (!folder.exists()) {
                throw new MessagingException("The folder DO NOT EXIST in email address");
            }
            folder.open(2);
            for (Message message : messages = folder.getMessages()) {
                message.setFlag(Flags.Flag.DELETED, true);
            }
            folder.close(true);
        }
        finally {
            session.getTransport().close();
        }
    }

    public static void deleteAllMessages(String email, String password) throws MessagingException {
        EmailService.deleteAllMessages(DEFAULT_EMAIL_FOLDER, email, password);
    }

    static {
        urlPattern = Pattern.compile("(?:^|[\\W])((ht|f)tp(s?)://|www\\.)(([\\w\\-]+\\.)+?([\\w\\-.~]+/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]*$~@!:/{};']*)", 42);
    }
}

