/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.driver;

import com.crowdar.core.JsonUtils;
import com.crowdar.core.PropertyManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.EncryptableProperties;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;

public enum ProjectTypeEnum {
    GENERIC{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            String driverClass = PropertyManager.getProperty("crowdar.projectType.localDriverType");
            if (driverClass.isEmpty()) {
                String msg = String.format("Error getting driver type -- For local runs you need to specify a valid crowdar.localDriverType property. /r Current Values is '%s'", driverClass);
                logger.error((Object)msg);
                throw new RuntimeException(msg);
            }
            Class<?> localDriverImplementation = null;
            try {
                localDriverImplementation = Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Invalid value for localDriverImplementation: " + driverClass);
            }
            return localDriverImplementation;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            Class<?> remoteDriverImplementation;
            String driverClass = PropertyManager.getProperty("crowdar.projectType.remoteDriverType");
            if (driverClass.isEmpty()) {
                String msg = String.format("Error getting driver type -- For remote runs you need to specify a valid crowdar.remoteDriverType property. /r Current Values is '%s'", driverClass);
                logger.error((Object)msg);
                throw new RuntimeException(msg);
            }
            try {
                remoteDriverImplementation = Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Invalid value for remoteDriverImplementation: " + driverClass);
            }
            return remoteDriverImplementation;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    }
    ,
    WEB_CHROME{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return ChromeDriver.class;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return RemoteWebDriver.class;
        }

        @Override
        public String getName() {
            return "Chrome";
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    }
    ,
    WEB_FIREFOX{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return FirefoxDriver.class;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return RemoteWebDriver.class;
        }

        @Override
        public String getName() {
            return "Firefox";
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    }
    ,
    WEB_EDGE{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return EdgeDriver.class;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return RemoteWebDriver.class;
        }

        @Override
        public String getName() {
            return "Edge";
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    }
    ,
    WEB_IE{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return InternetExplorerDriver.class;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return RemoteWebDriver.class;
        }

        @Override
        public String getName() {
            return "InternetExplorer";
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    }
    ,
    WEB_SAFARI{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return SafariDriver.class;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return RemoteWebDriver.class;
        }

        @Override
        public String getName() {
            return "Safari";
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    }
    ,
    MOBILE_ANDROID{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return null;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return AndroidDriver.class;
        }

        @Override
        public String getName() {
            return "Android";
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    }
    ,
    MOBILE_IOS{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return IOSDriver.class;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return this.getLocalDriverImplementation();
        }

        @Override
        public String getName() {
            return "Ios";
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    }
    ,
    API{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return null;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Properties getProperties() {
            EncryptableProperties properties = new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
            properties.put("crowdar.report.disable_screenshot_on_failure", "true");
            properties.put("crowdar.report.stackTraceDetail", "true");
            return properties;
        }
    }
    ,
    DATABASE{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return null;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Properties getProperties() {
            EncryptableProperties properties = new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
            properties.put("crowdar.report.disable_screenshot_on_failure", "true");
            properties.put("crowdar.report.stackTraceDetail", "true");
            return properties;
        }
    }
    ,
    WIN32{

        @Override
        public Class<? extends RemoteWebDriver> getLocalDriverImplementation() {
            return null;
        }

        @Override
        public Class<? extends RemoteWebDriver> getRemoteDriverImplementation() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Properties getProperties() {
            return new EncryptableProperties((StringEncryptor)new StandardPBEStringEncryptor());
        }
    };

    private static Logger logger;
    public static final String PROJECT_TYPE_KEY = "crowdar.projectType";

    public abstract Class<? extends RemoteWebDriver> getLocalDriverImplementation();

    public abstract Class<? extends RemoteWebDriver> getRemoteDriverImplementation();

    public abstract String getName();

    public abstract Properties getProperties();

    public DesiredCapabilities getDesiredCapabilities() {
        String path = PropertyManager.getProperty("crowdar.projectType.driverCapabilities.jsonFile");
        if (path == null || path.isEmpty()) {
            String msg = String.format("Error creating driver -- Please define property crowdar.projectType.driverCapabilities.jsonFile in config.property properly", new Object[0]);
            logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        TreeMap result = null;
        try {
            String capabilities = JsonUtils.getJSON(Paths.get(path, new String[0]));
            capabilities = JsonUtils.replaceVarsFromPropertyManager(capabilities);
            result = (TreeMap)new ObjectMapper().readValue(capabilities, TreeMap.class);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return new DesiredCapabilities(result);
    }

    public static ProjectTypeEnum get(String key) {
        try {
            return Enum.valueOf(ProjectTypeEnum.class, key);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid value for enum ProjectTypeEnum : " + key);
        }
    }

    static {
        logger = Logger.getLogger(ProjectTypeEnum.class);
    }
}

