/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.driver;

import com.crowdar.core.PropertyManager;
import com.crowdar.driver.DriverFactory;
import com.crowdar.driver.ProjectTypeEnum;
import com.crowdar.driver.setupStrategy.SetupStrategy;
import io.appium.java_client.AppiumDriver;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DriverManager {
    private static ThreadLocal<RemoteWebDriver> localDriver = new ThreadLocal();

    private DriverManager() {
    }

    public static void initialize(Map<String, ?> extraCapabilities) {
        if (!DriverManager.isDriverCreated() || !DriverManager.isAValidDriver()) {
            if (localDriver.get() != null) {
                localDriver.remove();
            }
            localDriver.set(DriverFactory.createDriver(extraCapabilities));
        }
    }

    public static void initialize(ProjectTypeEnum projectType, SetupStrategy setupStrategy, URL driverHub, Map<String, ?> extraCapabilities) throws Exception {
        if (!DriverManager.isDriverCreated() || !DriverManager.isAValidDriver()) {
            if (localDriver.get() != null) {
                localDriver.remove();
            }
        } else {
            throw new Exception("Driver initialized!");
        }
        localDriver.set(DriverFactory.createDriver(projectType, setupStrategy, driverHub, extraCapabilities));
    }

    public static RemoteWebDriver getDriverInstance() {
        if (!DriverManager.isDriverCreated() || !DriverManager.isAValidDriver()) {
            if (localDriver.get() != null) {
                localDriver.remove();
            }
            localDriver.set(DriverFactory.createDriver());
        }
        return localDriver.get();
    }

    public static void dismissCurrentDriver() {
        if (DriverManager.isDriverCreated()) {
            localDriver.get().quit();
            localDriver.remove();
        }
    }

    private static boolean isDriverCreated() {
        return localDriver.get() != null;
    }

    private static boolean isAValidDriver() {
        return localDriver.get().getSessionId() != null;
    }

    public static void dismissMobileDriver() {
        ((AppiumDriver)DriverManager.getDriverInstance()).closeApp();
        DriverManager.dismissCurrentDriver();
    }

    public static void resetDriver() {
        DriverManager.dismissCurrentDriver();
    }

    public static String getName() {
        return ProjectTypeEnum.get(PropertyManager.getProperty("crowdar.projectType")).getName();
    }
}

