/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.driver;

import com.crowdar.core.PropertyManager;
import com.crowdar.driver.ProjectTypeEnum;
import com.crowdar.driver.setupStrategy.SetupStrategy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;

class DriverFactory {
    private static Logger logger = Logger.getLogger(DriverFactory.class);
    private static final String DEFAULT_STRATEGY = "NoneStrategy";
    private static final String STRATEGY_CLASS = "com.crowdar.driver.setupStrategy.%s";

    DriverFactory() {
    }

    public static RemoteWebDriver createDriver() {
        try {
            ProjectTypeEnum projectType = DriverFactory.getProjectType();
            SetupStrategy setupStrategy = DriverFactory.getStrategy();
            URL driverHub = DriverFactory.getDriverHub();
            return DriverFactory.createDriver(projectType, setupStrategy, driverHub, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnreachableBrowserException e) {
            logger.error((Object)e.getCause());
            throw new RuntimeException("Error creating driver", e.getCause());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("error loading strategy class: com.crowdar.driver.setupStrategy." + PropertyManager.getProperty("crowdar.setupStrategy")));
            logger.error((Object)"Verify if path exist.");
            throw new RuntimeException("Error creating driver");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static RemoteWebDriver createDriver(Map<String, ?> extraCapabilities) {
        try {
            ProjectTypeEnum projectType = DriverFactory.getProjectType();
            SetupStrategy setupStrategy = DriverFactory.getStrategy();
            URL driverHub = DriverFactory.getDriverHub();
            return DriverFactory.createDriver(projectType, setupStrategy, driverHub, extraCapabilities);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnreachableBrowserException e) {
            logger.error((Object)e.getCause());
            throw new RuntimeException("Error creating driver", e.getCause());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("error loading strategy class: com.crowdar.driver.setupStrategy." + PropertyManager.getProperty("crowdar.setupStrategy")));
            logger.error((Object)"Verify if path exist.");
            throw new RuntimeException("Error creating driver");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static RemoteWebDriver createDriver(ProjectTypeEnum projectType, SetupStrategy setupStrategy, URL driverHub, Map<String, ?> extraCapabilities) {
        try {
            RemoteWebDriver driver;
            setupStrategy.beforeDriverStartSetup(projectType);
            DesiredCapabilities capabilities = DriverFactory.getCapabilities(projectType.getDesiredCapabilities(), extraCapabilities);
            if (driverHub == null) {
                Constructor<? extends RemoteWebDriver> constructor = projectType.getLocalDriverImplementation().getDeclaredConstructor(Capabilities.class);
                driver = constructor.newInstance(capabilities);
            } else {
                Constructor<? extends RemoteWebDriver> constructor = projectType.getRemoteDriverImplementation().getDeclaredConstructor(URL.class, Capabilities.class);
                driver = constructor.newInstance(driverHub, capabilities);
            }
            setupStrategy.afterDriverStartSetup(driver);
            return driver;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | UnreachableBrowserException e) {
            logger.error((Object)e.getCause());
            throw new RuntimeException("Error creating driver", e.getCause());
        }
    }

    private static URL getDriverHub() throws MalformedURLException {
        URL driverHub = null;
        if (!StringUtils.isEmpty((String)PropertyManager.getProperty("crowdar.driverHub"))) {
            driverHub = new URL(PropertyManager.getProperty("crowdar.driverHub"));
        }
        return driverHub;
    }

    private static SetupStrategy getStrategy() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String strategy = PropertyManager.getProperty("crowdar.setupStrategy");
        Class<?> StrategyClass = StringUtils.isEmpty((String)strategy) ? Class.forName(String.format(STRATEGY_CLASS, DEFAULT_STRATEGY)) : Class.forName(String.format(STRATEGY_CLASS, strategy));
        SetupStrategy setupStrategy = (SetupStrategy)StrategyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return setupStrategy;
    }

    private static ProjectTypeEnum getProjectType() {
        ProjectTypeEnum projectType = ProjectTypeEnum.get(PropertyManager.getProperty("crowdar.projectType"));
        return projectType;
    }

    private static DesiredCapabilities getCapabilities(DesiredCapabilities desiredCapabilities, Map<String, ?> extraCapabilities) {
        if (extraCapabilities != null) {
            desiredCapabilities = desiredCapabilities.merge((Capabilities)new DesiredCapabilities(extraCapabilities));
        }
        return desiredCapabilities;
    }
}

