/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core.pageObjects;

import com.crowdar.core.Constants;
import com.crowdar.core.LocatorManager;
import com.crowdar.driver.DriverManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Wait;
import org.openqa.selenium.support.ui.WebDriverWait;

@Deprecated
public abstract class PageBase {
    public static String BASE_URL;
    protected String url;
    protected RemoteWebDriver driver;
    protected WebDriverWait wait;
    protected FluentWait<RemoteWebDriver> fluentWait;

    public PageBase() {
    }

    public PageBase(RemoteWebDriver driver) {
        this.initialize(driver);
    }

    private void initialize(RemoteWebDriver driver) {
        this.driver = driver;
        this.wait = new WebDriverWait((WebDriver)driver, Constants.getWaitForElementTimeout());
        this.fluentWait = new FluentWait((Object)driver).withTimeout(Duration.ofSeconds(Constants.getWaitForElementTimeout())).pollingEvery(Duration.ofMillis(10L)).ignoring(NoSuchElementException.class);
    }

    public Logger getLogger() {
        return Logger.getLogger(this.getClass().asSubclass(this.getClass()));
    }

    public void click(String locatorName) {
        WebElement element = this.waitClickable(locatorName);
        this.click(element);
    }

    protected void click(WebElement element) {
        element.click();
    }

    public void setInput(String locatorName, String value) {
        this.setInput(locatorName, value, false, false);
    }

    public void setInput(String locatorName, String value, boolean clickAndClear) {
        this.setInput(locatorName, value, clickAndClear, clickAndClear);
    }

    public void setInput(String locatorName, String value, boolean click, boolean clear) {
        WebElement element = this.waitVisibility(locatorName);
        this.setInput(element, value, click, clear);
    }

    protected void setInput(WebElement element, String value, boolean click, boolean clear) {
        if (click) {
            element.click();
        }
        if (clear) {
            element.clear();
        }
        element.sendKeys(new CharSequence[]{value});
    }

    public String getText(String locatorName) {
        WebElement element = this.waitPresence(locatorName);
        return element.getText();
    }

    public String getAttribute(String locatorName, String attribute) {
        WebElement element = this.waitPresence(locatorName);
        return element.getAttribute(attribute);
    }

    private WebElement getElement(By locator) {
        return this.getDriver().findElement(locator);
    }

    private List<WebElement> getElements(By locator) {
        return this.getDriver().findElements(locator);
    }

    public WebElement getElement(String locatorName) {
        By locator = LocatorManager.getLocator(locatorName, new String[0]);
        return this.getElement(locator);
    }

    public List<WebElement> getElements(String locatorName) {
        By locator = LocatorManager.getLocator(locatorName, new String[0]);
        return this.getElements(locator);
    }

    public WebElement waitVisibility(String locatorName) {
        By locator = LocatorManager.getLocator(locatorName, new String[0]);
        return (WebElement)this.getFluentWait().until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
    }

    public List<WebElement> waitVisibilities(String locatorName) {
        By locator = LocatorManager.getLocator(locatorName, new String[0]);
        return (List)this.getFluentWait().until((Function)ExpectedConditions.visibilityOfAllElementsLocatedBy((By)locator));
    }

    public WebElement waitPresence(String locatorName) {
        By locator = LocatorManager.getLocator(locatorName, new String[0]);
        return (WebElement)this.getFluentWait().until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
    }

    public List<WebElement> waitPresences(String locatorName) {
        By locator = LocatorManager.getLocator(locatorName, new String[0]);
        return (List)this.getFluentWait().until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)locator));
    }

    public WebElement waitClickable(String locatorName) {
        By locator = LocatorManager.getLocator(locatorName, new String[0]);
        return (WebElement)this.getFluentWait().until((Function)ExpectedConditions.elementToBeClickable((By)locator));
    }

    public void waitInvisibility(String locatorName) {
        By locator = LocatorManager.getLocator(locatorName, new String[0]);
        this.getFluentWait().until((Function)ExpectedConditions.invisibilityOfElementLocated((By)locator));
    }

    public void waitInvisibilities(String locatorName) {
        List<WebElement> elements = this.getElements(locatorName);
        this.getFluentWait().until((Function)ExpectedConditions.invisibilityOfAllElements(elements));
    }

    public boolean isVisible(String locatorName) {
        return this.getElement(locatorName).isDisplayed();
    }

    public boolean isEnabled(String locatorName) {
        return this.getElement(locatorName).isEnabled();
    }

    public boolean isSelected(String locatorName) {
        return this.getElement(locatorName).isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPresent(String locatorName) {
        this.driver.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        try {
            this.getElement(locatorName);
            boolean bl = true;
            return bl;
        }
        catch (NoSuchElementException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.driver.manage().timeouts().implicitlyWait(Constants.getWaitImlicitTimeout(), TimeUnit.SECONDS);
        }
    }

    public void setCheckbox(String locatorName, boolean check) {
        WebElement checkbox = this.waitClickable(locatorName);
        boolean isSelected = checkbox.isSelected();
        if (isSelected && !check) {
            checkbox.click();
        } else if (isSelected && check) {
            checkbox.click();
        }
    }

    public RemoteWebDriver getDriver() {
        if (this.driver == null) {
            this.initialize(DriverManager.getDriverInstance());
        }
        return this.driver;
    }

    public WebDriverWait getWait() {
        return this.wait;
    }

    public Wait<RemoteWebDriver> getFluentWait() {
        return this.fluentWait;
    }

    @Deprecated
    public WebElement getWebElement(By locator) {
        return (WebElement)this.getWait().until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
    }

    @Deprecated
    public List<WebElement> getWebElements(By locator) {
        return (List)this.getWait().until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)locator));
    }

    @Deprecated
    public void clickElement(By locator) {
        WebElement element = this.getWebElement(locator);
        this.clickElement(element);
    }

    @Deprecated
    public void clickElement(WebElement element) {
        element.click();
    }

    @Deprecated
    public void completeField(By locator, String value) {
        WebElement element = this.getWebElement(locator);
        this.completeField(element, value);
    }

    @Deprecated
    public void completeField(WebElement element, String value) {
        this.clickElement(element);
        element.clear();
        this.completeFieldWithoutClick(element, value);
    }

    @Deprecated
    public void completeFieldWithoutClear(By locator, String value) {
        WebElement element = this.getWebElement(locator);
        this.clickElement(element);
        this.completeFieldWithoutClick(element, value);
    }

    @Deprecated
    public void completeFieldWithoutClick(By locator, String value) {
        WebElement element = this.getWebElement(locator);
        this.completeFieldWithoutClick(element, value);
    }

    @Deprecated
    public void completeFieldWithoutClear(WebElement element, String value) {
        this.clickElement(element);
        element.sendKeys(new CharSequence[]{value});
    }

    @Deprecated
    public void completeFieldWithoutClick(WebElement element, String value) {
        element.clear();
        element.sendKeys(new CharSequence[]{value});
    }

    @Deprecated
    public String getElementText(By locator) {
        WebElement element = this.getWebElement(locator);
        return this.getElementText(element);
    }

    @Deprecated
    public String getElementText(WebElement element) {
        return element.getText();
    }

    @Deprecated
    public String getInputValue(By locator) {
        WebElement element = this.getWebElement(locator);
        return this.getInputValue(element);
    }

    @Deprecated
    public String getInputValue(WebElement element) {
        return element.getAttribute("value");
    }

    @Deprecated
    public void selectCheckbox(By locator) {
        WebElement checkbox = this.driver.findElement(locator);
        if (!checkbox.isSelected()) {
            checkbox.click();
        }
    }

    @Deprecated
    public void deselectCheckbox(By locator) {
        WebElement checkbox = this.driver.findElement(locator);
        if (checkbox.isSelected()) {
            checkbox.click();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isElementPresent(By locator) {
        this.driver.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        try {
            this.getDriver().findElement(locator);
            boolean bl = true;
            return bl;
        }
        catch (NoSuchElementException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.driver.manage().timeouts().implicitlyWait(Constants.getWaitImlicitTimeout(), TimeUnit.SECONDS);
        }
    }

    @Deprecated
    public boolean isElementVisible(WebElement element) {
        return element.isDisplayed();
    }

    @Deprecated
    public boolean isElementVisible(By locator) {
        return this.isElementVisible(this.getWebElement(locator));
    }

    @Deprecated
    public boolean waitAndCheckElementPresent(By locator) {
        try {
            this.getWait().until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isElementPresent(WebElement element, By locator) {
        this.driver.manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        try {
            element.findElement(locator);
            boolean bl = true;
            return bl;
        }
        catch (NoSuchElementException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.driver.manage().timeouts().implicitlyWait(Constants.getWaitImlicitTimeout(), TimeUnit.SECONDS);
        }
    }

    @Deprecated
    public boolean isInputElementEmpty(By inputLocator) {
        return this.isInputElementEmpty(this.getWebElement(inputLocator));
    }

    @Deprecated
    public boolean isInputElementEmpty(WebElement element) {
        return element.getAttribute("value").isEmpty();
    }

    @Deprecated
    public boolean isElementEmpty(By locator) {
        return this.isElementEmpty(this.getWebElement(locator));
    }

    @Deprecated
    public boolean isElementEmpty(WebElement element) {
        return element.getText().isEmpty();
    }

    @Deprecated
    public void waitForElementDisappears(By locator) {
        this.getFluentWait().until((Function)ExpectedConditions.invisibilityOfElementLocated((By)locator));
    }

    @Deprecated
    public void waitForElementVisibility(By locator) {
        this.getFluentWait().until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
    }

    @Deprecated
    public void waitForElementInvisibility(By locator) {
        this.getFluentWait().until((Function)ExpectedConditions.invisibilityOfElementLocated((By)locator));
    }

    @Deprecated
    public void waitForElementClickable(By locator) {
        this.getFluentWait().until((Function)ExpectedConditions.elementToBeClickable((By)locator));
    }

    @Deprecated
    public void waitForElementPresence(By locator) {
        this.getFluentWait().until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
    }

    public void setTextToClipboard(String value) {
        StringSelection stringSelection = new StringSelection(value);
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    public void waitUntilElementDissappear(By locator) {
        if (this.isElementPresent(locator)) {
            this.getWait().until((Function)ExpectedConditions.invisibilityOfElementLocated((By)locator));
        }
    }

    @Deprecated
    public boolean isElementEnabled(WebElement element) {
        return element.isEnabled();
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            this.getLogger().error((Object)"Error in sleep: ".concat(e.getMessage()));
            e.printStackTrace();
        }
    }
}

