/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core.actions;

import com.crowdar.core.Constants;
import com.crowdar.core.actions.ActionManager;
import com.crowdar.driver.DriverManager;
import java.util.Iterator;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Select;

public class WebActionManager
extends ActionManager {
    public static void click(String locatorName, String ... locatorReplacementValue) {
        WebActionManager.click(locatorName, true, locatorReplacementValue);
    }

    public static void click(String locatorName, Boolean scroll, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.click(element, scroll);
    }

    protected static void click(WebElement element) {
        WebActionManager.click(element, true);
    }

    protected static void click(WebElement element, Boolean scroll) {
        if (scroll.booleanValue()) {
            WebActionManager.scroll(element);
        }
        ActionManager.click(element);
    }

    private static void scroll(WebElement element) {
        RemoteWebDriver jse = DriverManager.getDriverInstance();
        jse.executeScript("arguments[0].scrollIntoView()", new Object[]{element});
    }

    public static void maximizeWindow() {
        DriverManager.getDriverInstance().manage().window().maximize();
    }

    public static void navigateToURL(String url) {
        DriverManager.getDriverInstance().get(url);
    }

    public static void navigateTo(String url) {
        DriverManager.getDriverInstance().get(url);
    }

    public static void switchToLastTab() {
        String lastHandle = "";
        Iterator iterator = DriverManager.getDriverInstance().getWindowHandles().iterator();
        while (iterator.hasNext()) {
            String winHandle;
            lastHandle = winHandle = (String)iterator.next();
        }
        DriverManager.getDriverInstance().switchTo().window(lastHandle);
    }

    public static void waitTabOpening() throws InterruptedException {
        int attempts = 0;
        RemoteWebDriver wd = DriverManager.getDriverInstance();
        long wait = Constants.getWaitScriptTimeout() * 2L;
        while (wd.getWindowHandles().size() == 1 && (long)attempts <= wait) {
            Thread.sleep(500L);
            ++attempts;
        }
    }

    private static Select getSelect(WebElement element) {
        return new Select(element);
    }

    protected static void setDropdownByText(WebElement element, String text) {
        Select dropdown = WebActionManager.getSelect(element);
        dropdown.selectByVisibleText(text);
    }

    public static void setDropdownByText(String locatorName, String text, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.setDropdownByText(element, text);
    }

    public static void setDropdownByValue(String locatorName, String text, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.setDropdownByValue(element, text);
    }

    protected static void setDropdownByValue(WebElement element, String value) {
        Select dropdown = WebActionManager.getSelect(element);
        dropdown.selectByValue(value);
    }

    public static void setDropdownByVisibleText(String locatorName, String text, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.setDropdownByVisibleText(element, text);
    }

    protected static void setDropdownByVisibleText(WebElement element, String value) {
        Select dropdown = WebActionManager.getSelect(element);
        dropdown.selectByVisibleText(value);
    }

    public static void setDropdownByIndex(String locatorName, Integer index, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.setDropdownByIndex(element, index);
    }

    protected static void setDropdownByIndex(WebElement element, Integer index) {
        Select dropdown = WebActionManager.getSelect(element);
        dropdown.selectByIndex(index.intValue());
    }

    public static WebElement getDropdownSelectedOption(String locatorName, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        return WebActionManager.getDropdownSelectedOption(element);
    }

    protected static WebElement getDropdownSelectedOption(WebElement element) {
        Select dropdown = WebActionManager.getSelect(element);
        return dropdown.getFirstSelectedOption();
    }

    public static List<WebElement> getDropdownAllSelectedOptions(String locatorName, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        return WebActionManager.getDropdownAllSelectedOptions(element);
    }

    protected static List<WebElement> getDropdownAllSelectedOptions(WebElement element) {
        Select dropdown = WebActionManager.getSelect(element);
        return dropdown.getAllSelectedOptions();
    }

    protected static void deselectDropdownAll(WebElement element) {
        Select dropdown = WebActionManager.getSelect(element);
        dropdown.deselectAll();
    }

    public static void deselectDropdownAll(String locatorName, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.deselectDropdownAll(element);
    }

    protected static void deselectDropdownByValue(WebElement element, String value) {
        Select dropdown = WebActionManager.getSelect(element);
        dropdown.deselectByValue(value);
    }

    public static void deselectDropdownByValue(String locatorName, String value, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.deselectDropdownByValue(element, value);
    }

    protected static void deselectDropdownByText(WebElement element, String text) {
        Select dropdown = WebActionManager.getSelect(element);
        dropdown.deselectByValue(text);
    }

    public static void deselectDropdownByText(String locatorName, String value, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.deselectDropdownByText(element, value);
    }

    protected static void deselectDropdownByIndex(WebElement element, int index) {
        Select dropdown = WebActionManager.getSelect(element);
        dropdown.deselectByIndex(index);
    }

    public static void deselectDropdownByIndex(String locatorName, int index, String ... locatorReplacementValue) {
        WebElement element = WebActionManager.waitVisibility(locatorName, locatorReplacementValue);
        WebActionManager.deselectDropdownByIndex(element, index);
    }

    protected static void dragAndDrop(WebElement elementToDrag, WebElement elementToReplace) {
        RemoteWebDriver jse = DriverManager.getDriverInstance();
        jse.executeScript("arguments[0].scrollIntoView()", new Object[]{elementToReplace});
        new Actions((WebDriver)DriverManager.getDriverInstance()).dragAndDrop(elementToDrag, elementToReplace).perform();
    }

    public static void dragAndDrop(String locatorToDrag, String locatorToReplace) {
        WebElement elementToDrag = WebActionManager.waitVisibility(locatorToDrag, new String[0]);
        WebElement elementToReplace = WebActionManager.waitVisibility(locatorToReplace, new String[0]);
        WebActionManager.dragAndDrop(elementToDrag, elementToReplace);
    }
}

