/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core.actions;

import com.crowdar.core.actions.ActionManager;
import com.crowdar.driver.DriverManager;
import io.appium.java_client.MobileBy;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.ios.IOSElement;
import java.util.HashMap;
import org.openqa.selenium.WebElement;

public class MobileActionManager
extends ActionManager {
    public static void setInput(String locatorName, String value, String placeholder) {
        String elementText = MobileActionManager.getText(locatorName, new String[0]);
        boolean clear = !elementText.equals(placeholder);
        MobileActionManager.setInput(locatorName, value, Boolean.TRUE, clear, new String[0]);
    }

    public static void clickOptionSpinner(String spinnerLocatorName, String option) {
        MobileActionManager.click(spinnerLocatorName, new String[0]);
        MobileActionManager.clickOptionSpinner(option, Boolean.FALSE);
    }

    public static void clickOptionSpinner(String spinnerLocatorName, String option, boolean startWith) {
        MobileActionManager.click(spinnerLocatorName, new String[0]);
        MobileActionManager.clickOptionSpinner(option, startWith);
    }

    public static void clickOptionSpinner(String spinnerLocator, String option, String filterLocator, String filter) {
        MobileActionManager.click(spinnerLocator, new String[0]);
        MobileActionManager.setInput(filterLocator, filter, Boolean.TRUE, Boolean.TRUE, new String[0]);
        MobileActionManager.clickOptionSpinner(option, Boolean.FALSE);
    }

    public static void clickOptionSpinner(String spinnerLocator, String option, String filterLocator, String filter, boolean startWith) {
        MobileActionManager.click(spinnerLocator, new String[0]);
        MobileActionManager.setInput(filterLocator, filter, Boolean.TRUE, Boolean.TRUE, new String[0]);
        MobileActionManager.clickOptionSpinner(option, startWith);
    }

    public static void clickOptionSpinner(String spinnerLocator, String option, String filterLocator) {
        MobileActionManager.clickOptionSpinner(spinnerLocator, option, filterLocator, option);
    }

    private static void clickOptionSpinner(String option, boolean startWith) {
        WebElement element = null;
        String findTypeAndroid = "text";
        String findTypeIos = "==";
        if (startWith) {
            findTypeAndroid = "textContains";
            findTypeIos = "BEGINSWITH";
        }
        if (MobileActionManager.isAndroid()) {
            element = MobileActionManager.scrollAndroid(findTypeAndroid, option, 0);
        } else if (MobileActionManager.isIos()) {
            element = DriverManager.getDriverInstance().findElement(MobileBy.iOSNsPredicateString((String)("label " + findTypeIos + " '" + option + "'")));
            MobileActionManager.scrollIOS((IOSElement)element);
        }
        element.click();
    }

    private static WebElement scrollAndroid(String locatorType, String locatorValue, int index) {
        String locator = String.format("new UiScrollable(new UiSelector().scrollable(true).instance(3)).scrollIntoView(new UiSelector().%s(\"%s\").instance(0).index(%d))", locatorType, locatorValue, index);
        return DriverManager.getDriverInstance().findElement(MobileBy.AndroidUIAutomator((String)locator));
    }

    public static void scrollIOS(String locatorName) {
        IOSElement element = (IOSElement)MobileActionManager.getElement(locatorName, new String[0]);
        MobileActionManager.scrollIOS(element);
    }

    private static void scrollIOS(IOSElement element) {
        String elementID = element.getId();
        HashMap<String, String> scrollObject = new HashMap<String, String>();
        scrollObject.put("element", elementID);
        scrollObject.put("direction", "down");
        DriverManager.getDriverInstance().executeScript("mobile:scroll", new Object[]{scrollObject});
    }

    public static boolean isAndroid() {
        return DriverManager.getDriverInstance() instanceof AndroidDriver;
    }

    public static boolean isIos() {
        return DriverManager.getDriverInstance() instanceof IOSDriver;
    }
}

