/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core.actions;

import com.crowdar.core.Constants;
import com.crowdar.core.LocatorManager;
import com.crowdar.driver.DriverManager;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Wait;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class ActionManager {
    private static ThreadLocal<WebDriverWait> wait = new ThreadLocal();
    private static ThreadLocal<FluentWait<RemoteWebDriver>> fluentWait = new ThreadLocal();

    public static void clean() {
        wait.remove();
        fluentWait.remove();
    }

    public static WebDriverWait getWait() {
        if (wait.get() == null) {
            wait.set(new WebDriverWait((WebDriver)DriverManager.getDriverInstance(), Constants.getWaitForElementTimeout()));
        }
        return wait.get();
    }

    public static Wait<RemoteWebDriver> getFluentWait() {
        if (fluentWait.get() == null) {
            fluentWait.set((FluentWait<RemoteWebDriver>)new FluentWait((Object)DriverManager.getDriverInstance()).withTimeout(Duration.ofSeconds(Constants.getFluentWaitTimeoutInSeconds())).pollingEvery(Duration.ofMillis(Constants.getFluentWaitRequestFrequencyInMillis())).ignoring(NoSuchElementException.class));
        }
        return (Wait)fluentWait.get();
    }

    public static void click(String locatorName, String ... locatorReplacementValue) {
        WebElement element = ActionManager.waitClickable(locatorName, locatorReplacementValue);
        ActionManager.click(element);
    }

    protected static void click(WebElement element) {
        element.click();
    }

    public static void setInput(String locatorName, String value, String ... locatorReplacementValue) {
        ActionManager.setInput(locatorName, value, Boolean.FALSE, Boolean.FALSE, locatorReplacementValue);
    }

    public static void setInput(String locatorName, String value, Boolean clickAndClear, String ... locatorReplacementValue) {
        ActionManager.setInput(locatorName, value, clickAndClear, clickAndClear, locatorReplacementValue);
    }

    public static void setInput(String locatorName, String value, Boolean click, Boolean clear, String ... locatorReplacementValue) {
        WebElement element = ActionManager.waitVisibility(locatorName, locatorReplacementValue);
        ActionManager.setInput(element, value, click, clear);
    }

    protected static void setInput(WebElement element, String value, Boolean click, Boolean clear) {
        if (click.booleanValue()) {
            element.click();
        }
        if (clear.booleanValue()) {
            element.clear();
        }
        element.sendKeys(new CharSequence[]{value});
    }

    public static String getText(String locatorName, String ... locatorReplacementValue) {
        WebElement element = ActionManager.waitPresence(locatorName, locatorReplacementValue);
        return element.getText();
    }

    public static String getAttribute(String locatorName, String attribute, String ... locatorReplacementValue) {
        WebElement element = ActionManager.waitPresence(locatorName, locatorReplacementValue);
        return element.getAttribute(attribute);
    }

    private static WebElement getElement(By locator) {
        return DriverManager.getDriverInstance().findElement(locator);
    }

    public static List<WebElement> getElements(String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        return ActionManager.getElements(locator);
    }

    private static List<WebElement> getElements(By locator) {
        return DriverManager.getDriverInstance().findElements(locator);
    }

    private static WebElement getElement(WebElement parent, By locator) {
        return parent.findElement(locator);
    }

    private static List<WebElement> getElements(WebElement parent, By locator) {
        return parent.findElements(locator);
    }

    public static WebElement getElement(String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        return ActionManager.getElement(locator);
    }

    public static WebElement getElement(String locatorParent, String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        WebElement parent = ActionManager.getElement(locatorParent, new String[0]);
        return ActionManager.getElement(parent, locator);
    }

    public static List<WebElement> getElements(String locatorParent, String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        WebElement parent = ActionManager.getElement(locatorParent, new String[0]);
        return ActionManager.getElements(parent, locator);
    }

    public static WebElement waitVisibility(String locatorName, String ... locatorReplacementArgs) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementArgs);
        return (WebElement)ActionManager.getFluentWait().until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
    }

    public static List<WebElement> waitVisibilities(String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        return (List)ActionManager.getFluentWait().until((Function)ExpectedConditions.visibilityOfAllElementsLocatedBy((By)locator));
    }

    public static WebElement waitPresence(String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        return (WebElement)ActionManager.getFluentWait().until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
    }

    public static List<WebElement> waitPresences(String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        return (List)ActionManager.getFluentWait().until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)locator));
    }

    public static WebElement waitClickable(String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        return (WebElement)ActionManager.getFluentWait().until((Function)ExpectedConditions.elementToBeClickable((By)locator));
    }

    public static void waitInvisibility(String locatorName, String ... locatorReplacementValue) {
        By locator = LocatorManager.getLocator(locatorName, locatorReplacementValue);
        ActionManager.getFluentWait().until((Function)ExpectedConditions.invisibilityOfElementLocated((By)locator));
    }

    public static void waitInvisibilities(String locatorName, String ... locatorReplacementValue) {
        List<WebElement> elements = ActionManager.getElements(locatorName, locatorReplacementValue);
        ActionManager.getFluentWait().until((Function)ExpectedConditions.invisibilityOfAllElements(elements));
    }

    public static boolean isVisible(String locatorName, String ... locatorReplacementValue) {
        return ActionManager.getElement(locatorName, locatorReplacementValue).isDisplayed();
    }

    public static boolean isEnabled(String locatorName, String ... locatorReplacementValue) {
        return ActionManager.getElement(locatorName, locatorReplacementValue).isEnabled();
    }

    public static boolean isSelected(String locatorName, String ... locatorReplacementValue) {
        return ActionManager.getElement(locatorName, locatorReplacementValue).isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPresent(String locatorName, String ... locatorReplacementValue) {
        DriverManager.getDriverInstance().manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        try {
            ActionManager.getElement(locatorName, locatorReplacementValue);
            boolean bl = true;
            return bl;
        }
        catch (NoSuchElementException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DriverManager.getDriverInstance().manage().timeouts().implicitlyWait(Constants.getWaitImlicitTimeout(), TimeUnit.SECONDS);
        }
    }

    public static void setCheckbox(String locatorName, Boolean check, String ... locatorReplacementValue) {
        WebElement checkbox = ActionManager.waitClickable(locatorName, locatorReplacementValue);
        boolean isSelected = checkbox.isSelected();
        if (isSelected && !check.booleanValue()) {
            checkbox.click();
        } else if (isSelected && check.booleanValue()) {
            checkbox.click();
        }
    }
}

