/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;

public class Utils {
    public static String getRandomNumber(int amount) {
        return RandomStringUtils.randomNumeric((int)amount);
    }

    public static String getRandomLetters(int amount) {
        return RandomStringUtils.randomAlphabetic((int)amount);
    }

    public static String getRandom(int amount, boolean letters, boolean numbers) {
        return RandomStringUtils.random((int)amount, (boolean)letters, (boolean)numbers);
    }

    public static String removeFirstAndLastChar(String text) {
        return text.substring(0, text.length() - 1).substring(1);
    }

    public static BigDecimal replaceDollarWithNumber(String value) {
        String newValue = value.replaceAll(" ", "").replace("US$", "");
        return new BigDecimal(newValue);
    }

    public static String dateToString(LocalDate date, String dateFormat) {
        return date.format(DateTimeFormatter.ofPattern(dateFormat));
    }

    public static LocalDate stringToDate(String date, String dateFormat) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(dateFormat));
    }

    public static String convertDateToFormatMMDDYYYY(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        return formatter.format(date);
    }

    public static int getOnlyNumbersFromString(String stringToReplace) {
        return Integer.parseInt(stringToReplace.replaceAll("\\D+", ""));
    }

    public static void deleteFileIfExists(String filePath) {
        try {
            Files.deleteIfExists(Paths.get(filePath, new String[0]));
        }
        catch (NoSuchFileException e) {
            System.out.println("No such file/directory exists");
        }
        catch (DirectoryNotEmptyException e) {
            System.out.println("Directory is not empty.");
        }
        catch (IOException e) {
            System.out.println("Invalid permissions.");
        }
        System.out.println("Deletion successful.");
    }

    public static <T> List<T> parseArrayToList(T[] array) {
        return Arrays.asList(array);
    }
}

