/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core;

import com.crowdar.driver.ProjectTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.EncryptableProperties;

public class PropertyManager {
    private static Logger logger = Logger.getLogger(PropertyManager.class);
    private static final String PROPERTY_FILE_NAME = "config.properties";
    private static ThreadLocal<Properties> properties = new ThreadLocal();

    private PropertyManager() {
    }

    private static Properties getProperties() {
        if (properties.get() == null) {
            try {
                PropertyManager.loadProperties();
            }
            catch (IOException var1) {
                var1.printStackTrace();
            }
        }
        return properties.get();
    }

    public static String getProperty(String propertyKey) {
        return PropertyManager.getProperties().getProperty(propertyKey);
    }

    public static boolean isPropertyPresentAndNotEmpty(String propertyKey) {
        return PropertyManager.getProperties().containsKey(propertyKey) && !PropertyManager.getProperties().getProperty(propertyKey).isEmpty();
    }

    private static void loadProperties() throws IOException {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        EncryptableProperties clientProperties = new EncryptableProperties((StringEncryptor)encryptor);
        InputStream inputStream = PropertyManager.class.getClassLoader().getResourceAsStream(PROPERTY_FILE_NAME);
        clientProperties.load(inputStream);
        properties.set(PropertyManager.getProjectTypeProperties((Properties)clientProperties));
        properties.get().putAll((Map<?, ?>)clientProperties);
    }

    private static Properties getProjectTypeProperties(Properties clientProperties) {
        return ProjectTypeEnum.get(clientProperties.getProperty("crowdar.projectType")).getProperties();
    }
}

