/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core;

import com.crowdar.core.DownloadManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.testng.Assert;

public class PDFManager {
    private static final String TEXT_NOT_PRESENT_ERROR_MESSAGE = "Text %s is not present in PDF.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPdfContent(String fileName) throws IOException {
        String text;
        try (PDDocument document = PDDocument.load((File)DownloadManager.getFile(fileName));){
            if (!document.isEncrypted()) {
                PDFTextStripper stripper = new PDFTextStripper();
                text = stripper.getText(document);
            } else {
                text = "PDF is encrypted";
            }
        }
        return text;
    }

    public static boolean isTextPresentInPDF(String fileName, String expectedText) throws IOException {
        return PDFManager.getPdfContent(fileName).contains(expectedText);
    }

    public static void isTextPresentInPDF(String fileName, List<String> expectedsText) throws IOException {
        String pdfContent = PDFManager.getPdfContent(fileName);
        for (String expectedText : expectedsText) {
            Assert.assertTrue((boolean)pdfContent.contains(expectedText), (String)String.format(TEXT_NOT_PRESENT_ERROR_MESSAGE, expectedText));
        }
    }
}

