/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core;

import com.crowdar.core.PropertyManager;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    private static ObjectMapper mapper = new ObjectMapper();

    private static ObjectMapper getMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    public static <T> T deserialize(String json, Class<T> type) {
        try {
            TypeFactory typeFactory = JsonUtils.getMapper().getTypeFactory();
            return (T)mapper.readValue(json, typeFactory.constructType(type));
        }
        catch (IOException e) {
            Logger.getLogger(JsonUtils.class).error((Object)e.getMessage());
            return null;
        }
    }

    public static String serialize(Object json) {
        String jsonResult = null;
        try {
            jsonResult = JsonUtils.getMapper().writeValueAsString(json);
        }
        catch (IOException e) {
            Logger.getLogger(JsonUtils.class).error((Object)e.getMessage());
        }
        return jsonResult;
    }

    public static boolean isJSONValid(Object jsonObject) {
        String jsonString = JsonUtils.serialize(jsonObject);
        return JsonUtils.isJSONValid(jsonString);
    }

    public static boolean isJSONValid(String json) {
        try {
            new JSONObject(json);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(json);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    public static String getJSONFromFile(String fileName) throws IOException {
        String path = System.getProperty("user.dir").concat(File.separator).concat("src").concat(File.separator).concat("test").concat(File.separator).concat("resources").concat(File.separator).concat("jsons").concat(File.separator).concat(fileName).concat(".json");
        return JsonUtils.getJSONFromPath(path);
    }

    public static String getJSONFromPath(String path) throws IOException {
        return JsonUtils.getJSON(Paths.get(path, new String[0]));
    }

    public static <T> T getJSONFromFileAsObject(String file, Class<T> valueType) throws IOException {
        String json = JsonUtils.getJSONFromFile(file);
        return (T)JsonUtils.getMapper().readValue(json, valueType);
    }

    public static <T> List<T> getListJSONFromFileAsObject(String file, Class<T> valueType) throws IOException {
        TypeFactory typeFactory = JsonUtils.getMapper().getTypeFactory();
        String json = JsonUtils.getJSONFromFile(file);
        return (List)JsonUtils.getMapper().readValue(json, (JavaType)typeFactory.constructCollectionType(List.class, valueType));
    }

    public static String getJSON(Path file) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        FileInputStream fis = new FileInputStream(file.toFile());
        JsonNode rootNode = mapper.readTree((InputStream)fis);
        return rootNode.toString();
    }

    public static String prettyJsonToCompact(String prettyJson) {
        JsonNode jsonNode = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            jsonNode = (JsonNode)objectMapper.readValue(prettyJson, JsonNode.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonNode.toString();
    }

    public static String replaceVarsFromPropertyManager(String jsonUnparsed) throws IOException {
        Handlebars handlebars = new Handlebars();
        Template template = handlebars.compileInline(jsonUnparsed);
        List vars = template.collect(new TagType[]{TagType.VAR});
        for (String var : vars) {
            jsonUnparsed = jsonUnparsed.replace("{{" + var + "}}", PropertyManager.getProperty(var));
        }
        return jsonUnparsed;
    }
}

