/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.core;

import com.crowdar.core.PropertyManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

public class DownloadManager {
    private static String getDownloadFolder() {
        return PropertyManager.getProperty("crowdar.download.folder");
    }

    protected static File getFile(String fileName) {
        return Paths.get(DownloadManager.getDownloadFolder(), fileName).toFile();
    }

    public static void deleteAllFiles() throws IOException {
        FileUtils.cleanDirectory((File)Paths.get(DownloadManager.getDownloadFolder(), new String[0]).toFile());
    }

    public static boolean isFileDownload(String fileName) {
        return DownloadManager.getFile(fileName).exists();
    }

    public static boolean isFileDownload(String fileName, WebDriver driver, long timeToWait) {
        DownloadManager.waitFileDownload(fileName, driver, timeToWait);
        return DownloadManager.getFile(fileName).exists();
    }

    private static void waitFileDownload(String fileName, WebDriver driver, long timeToWait) {
        FluentWait wait = new FluentWait((Object)driver).withTimeout(timeToWait, TimeUnit.SECONDS).pollingEvery(200L, TimeUnit.MILLISECONDS);
        File fileToCheck = Paths.get(DownloadManager.getDownloadFolder(), new String[0]).resolve(fileName).toFile();
        wait.until(wd -> fileToCheck.exists());
    }
}

