/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.api.rest;

import com.crowdar.api.rest.Headers;
import com.crowdar.api.rest.Response;
import com.crowdar.core.JsonUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.testng.Assert;

public class RestClient {
    private HttpHeaders headers;
    private static RestTemplate restTemplate;
    private static RestClient restClient;

    public static RestClient getRestClient() {
        if (restClient == null) {
            restClient = new RestClient();
        }
        return restClient;
    }

    public static RestClient getRestClient(RestTemplate restTemplate) {
        if (restClient == null) {
            restClient = new RestClient();
            RestClient.setRestTemplate(restTemplate);
        }
        return restClient;
    }

    public static void purge() {
        RestClient.setRestTemplate(null);
    }

    private RestClient() {
        RestClient.setRestTemplate(new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory()));
        List messageConverters = restTemplate.getMessageConverters();
        MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = new MappingJackson2HttpMessageConverter();
        mappingJackson2HttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaType.ALL));
        messageConverters.add(mappingJackson2HttpMessageConverter);
        messageConverters.add(new StringHttpMessageConverter(Charset.forName("UTF-8")));
    }

    private static RestTemplate getRestTemplate() {
        return restTemplate;
    }

    private static void setRestTemplate(RestTemplate newRestTemplate) {
        restTemplate = newRestTemplate;
    }

    private void setRequestHeaders(Map<String, String> headers) {
        this.headers = new HttpHeaders();
        this.headers.setAll(headers);
    }

    private HttpHeaders getRequestHeaders() {
        return this.headers;
    }

    public Response get(String url, Class<?> type, Object body, Map<String, String> urlParameters, Map<String, String> headers) {
        return this.createHTTPMethod(url, type, body, urlParameters, headers, HttpMethod.GET);
    }

    public Response post(String url, Class<?> type, Object body, Map<String, String> urlParameters, Map<String, String> headers) {
        return this.createHTTPMethod(url, type, body, urlParameters, headers, HttpMethod.POST);
    }

    public Response put(String url, Class<?> type, Object body, Map<String, String> urlParameters, Map<String, String> headers) {
        return this.createHTTPMethod(url, type, body, urlParameters, headers, HttpMethod.PUT);
    }

    public Response patch(String url, Class<?> type, Object body, Map<String, String> urlParameters, Map<String, String> headers) {
        return this.createHTTPMethod(url, type, body, urlParameters, headers, HttpMethod.PATCH);
    }

    public Response delete(String url, Class<?> type, Object body, Map<String, String> urlParameters, Map<String, String> headers) {
        return this.createHTTPMethod(url, type, body, urlParameters, headers, HttpMethod.DELETE);
    }

    private Response createHTTPMethod(String url, Class<?> type, Object body, Map<String, String> urlParameters, Map<String, String> headers, HttpMethod httpMethod) {
        URI uri = this.getURIWithURLQueryParameters(url, urlParameters);
        this.setRequestHeaders(headers);
        HttpEntity<Object> request = this.createRequest(body, this.getRequestHeaders());
        try {
            ResponseEntity response = RestClient.getRestTemplate().exchange(uri, httpMethod, request, type);
            Logger.getLogger(this.getClass()).info((Object)(">>>Response: " + response.toString()));
            return this.createResponse(response.getStatusCode().value(), "OK", response.getBody(), this.createResponseHeaders(response.getHeaders()));
        }
        catch (HttpClientErrorException | HttpServerErrorException e) {
            Logger.getLogger(this.getClass()).info((Object)(">>>Error Response: " + e.toString()));
            Object responseBody = JsonUtils.deserialize(e.getResponseBodyAsString(), type);
            if (responseBody == null) {
                Assert.fail((String)("Cannot cast error response in: " + type.getName() + ". Actual response: " + e.getStatusCode().value() + ", " + e.getResponseBodyAsString()));
            }
            return this.createResponse(e.getStatusCode().value(), e.getLocalizedMessage(), responseBody, this.createResponseHeaders(e.getResponseHeaders()));
        }
    }

    private Headers createResponseHeaders(HttpHeaders headers) {
        return new Headers(this.getHeaders(headers));
    }

    private HttpEntity<Object> createRequest(Object body, HttpHeaders headers) {
        if (body.toString().isEmpty()) {
            return new HttpEntity((MultiValueMap)headers);
        }
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    private Response createResponse(int statusCode, String message, Object response, Headers headers) {
        return new Response(statusCode, message, response, headers);
    }

    private Map<String, List<String>> getHeaders(HttpHeaders headers) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : headers.entrySet()) {
            map.put((String)entry.getKey(), (List)entry.getValue());
        }
        return map;
    }

    private URI getURIWithURLQueryParameters(String url, Map<String, String> urlParameters) {
        if (urlParameters.isEmpty()) {
            return this.getUriFromUrl(url);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        for (Map.Entry<String, String> entry : urlParameters.entrySet()) {
            builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        return builder.build().encode().toUri();
    }

    private URI getUriFromUrl(String url) {
        try {
            URI uri = new URI(url);
            return uri;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

