/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.api.rest;

import com.crowdar.api.rest.APIManager;
import com.crowdar.core.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class Request {
    private Object body;
    private String url;
    private String endpoint;
    private Map<String, String> headers;
    private Map<String, String> urlParameters;

    public String getCompleteUrl() {
        String completeUrl = this.url;
        if (StringUtils.isEmpty((String)this.url)) {
            completeUrl = APIManager.BASE_URL;
        }
        if (!StringUtils.isEmpty((String)this.endpoint)) {
            completeUrl = completeUrl.concat(this.endpoint);
        }
        return completeUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrl(String var) {
        return this.url.replace("{}", var);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Object getBody() {
        if (this.body == null) {
            return "";
        }
        if (JsonUtils.isJSONValid(this.body)) {
            return JsonUtils.serialize(this.body);
        }
        return this.body;
    }

    public Map<String, String> getHeaders() {
        if (MapUtils.isEmpty(this.headers)) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        this.getHeaders().put(key, value);
    }

    public Map<String, String> getUrlParameters() {
        if (MapUtils.isEmpty(this.urlParameters)) {
            this.urlParameters = new HashMap<String, String>();
        }
        return this.urlParameters;
    }

    public void addUrlParameter(String key, String value) {
        this.getUrlParameters().put(key, value);
    }

    public void setUrlParameters(Map<String, String> urlParameters) {
        this.urlParameters = urlParameters;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCompleteUrl());
        if (!this.getUrlParameters().isEmpty()) {
            builder.append(", ");
            builder.append(this.getUrlParameters());
        }
        if (!this.getHeaders().isEmpty()) {
            builder.append(", ");
            builder.append(this.getHeaders());
        }
        if (!this.getBody().toString().isEmpty()) {
            builder.append(", ");
            builder.append(this.getBody());
        }
        return builder.toString();
    }
}

