/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.api.rest;

import com.crowdar.api.rest.APIManager;
import com.crowdar.api.rest.Request;
import com.crowdar.api.rest.Response;
import com.crowdar.api.rest.RestClient;
import com.crowdar.core.JsonUtils;
import com.crowdar.util.ValidateUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.testng.Assert;

public class MethodsService {
    public static <T> Response get(Request req, Class<T> classModel) {
        return MethodsService.get(req, classModel, MethodsService.getRestClient());
    }

    public static <T> Response get(Request req, Class<T> classModel, RestClient restClient) {
        Response resp = restClient.get(req.getCompleteUrl(), classModel, req.getBody().toString(), req.getUrlParameters(), req.getHeaders());
        APIManager.setLastResponse(resp);
        return resp;
    }

    public static <T> Response get(String jsonName, Class<T> classModel) {
        return MethodsService.get(jsonName, classModel, null);
    }

    public static <T> Response get(String jsonName, Class<T> classModel, Map<String, String> jsonParameters) {
        Request req = MethodsService.getRequest(jsonName, jsonParameters);
        return MethodsService.get(req, classModel);
    }

    public static <T> Response post(Request req, Class<T> classModel) {
        return MethodsService.post(req, classModel, MethodsService.getRestClient());
    }

    public static <T> Response post(Request req, Class<T> classModel, RestClient restClient) {
        Response resp = restClient.post(req.getCompleteUrl(), classModel, req.getBody(), req.getUrlParameters(), req.getHeaders());
        APIManager.setLastResponse(resp);
        return resp;
    }

    public static <T> Response post(String jsonName, Class<T> classModel) {
        return MethodsService.post(jsonName, classModel, null);
    }

    public static <T> Response post(String jsonName, Class<T> classModel, Map<String, String> jsonParameters) {
        Request req = MethodsService.getRequest(jsonName, jsonParameters);
        return MethodsService.post(req, classModel);
    }

    public static <T> Response put(Request req, Class<T> classModel) {
        return MethodsService.put(req, classModel, MethodsService.getRestClient());
    }

    public static <T> Response put(Request req, Class<T> classModel, RestClient restClient) {
        Response resp = restClient.put(req.getCompleteUrl(), classModel, req.getBody().toString(), req.getUrlParameters(), req.getHeaders());
        APIManager.setLastResponse(resp);
        return resp;
    }

    public static <T> Response put(String jsonName, Class<T> classModel) {
        return MethodsService.put(jsonName, classModel, null);
    }

    public static <T> Response put(String jsonName, Class<T> classModel, Map<String, String> jsonParameters) {
        Request req = MethodsService.getRequest(jsonName, jsonParameters);
        return MethodsService.put(req, classModel);
    }

    public static <T> Response patch(Request req, Class<T> classModel) {
        return MethodsService.patch(req, classModel, MethodsService.getRestClient());
    }

    public static <T> Response patch(Request req, Class<T> classModel, RestClient restClient) {
        Response resp = restClient.patch(req.getCompleteUrl(), classModel, req.getBody().toString(), req.getUrlParameters(), req.getHeaders());
        APIManager.setLastResponse(resp);
        return resp;
    }

    public static <T> Response patch(String jsonName, Class<T> classModel) {
        return MethodsService.patch(jsonName, classModel, null);
    }

    public static <T> Response patch(String jsonName, Class<T> classModel, Map<String, String> jsonParameters) {
        Request req = MethodsService.getRequest(jsonName, jsonParameters);
        return MethodsService.patch(req, classModel);
    }

    public static <T> Response delete(Request req, Class<T> classModel) {
        return MethodsService.delete(req, classModel, MethodsService.getRestClient());
    }

    public static <T> Response delete(Request req, Class<T> classModel, RestClient restClient) {
        Response resp = restClient.delete(req.getCompleteUrl(), classModel, req.getBody().toString(), req.getUrlParameters(), req.getHeaders());
        APIManager.setLastResponse(resp);
        return resp;
    }

    public static <T> Response delete(String jsonName, Class<T> classModel) {
        return MethodsService.delete(jsonName, classModel, null);
    }

    public static <T> Response delete(String jsonName, Class<T> classModel, Map<String, String> jsonParameters) {
        Request req = MethodsService.getRequest(jsonName, jsonParameters);
        return MethodsService.delete(req, classModel);
    }

    protected static Request getRequest(String jsonFileName, Map<String, String> replacementParameters) {
        String jsonRequest = null;
        try {
            jsonRequest = JsonUtils.getJSONFromFile(jsonFileName);
        }
        catch (IOException e) {
            Logger.getLogger(MethodsService.class).error((Object)e.getMessage());
            Assert.fail((String)e.getMessage());
        }
        if (replacementParameters != null) {
            for (String key : replacementParameters.keySet()) {
                jsonRequest = jsonRequest.replace("{{" + key + "}}", replacementParameters.get(key));
            }
        }
        Request request = JsonUtils.deserialize(jsonRequest, Request.class);
        Logger.getLogger(MethodsService.class).info((Object)(">>>Request: " + request.toString()));
        return request;
    }

    public static RestClient getRestClient() {
        return RestClient.getRestClient();
    }

    public <T> void validateFields(List<T> actualList, List<T> expectedList) throws Exception {
        ValidateUtils.validateFields(actualList, expectedList);
    }

    public void validateFields(Object actual, Object expected) throws Exception {
        ValidateUtils.validateFields(actual, expected);
    }

    public void validateFields(Object actual, Object expected, Map<String, String> parameters) throws Exception {
    }

    public <T> void validateFields(List<T> actualList, List<T> expectedList, Map<String, String> parameters) throws Exception {
    }

    public void validateFields(String jsonExpectedPath, Object actual) throws Exception {
    }

    public <T> void validateFields(String jsonExpectedPath, List<T> actualList) throws Exception {
    }

    public void validateFields(String jsonExpectedPath, Object actual, Map<String, String> parameters) throws Exception {
    }

    public <T> void validateFields(String jsonExpectedPath, List<T> actualList, Map<String, String> parameters) throws Exception {
    }

    public void validateFields(Object actual) throws Exception {
    }

    public <T> void validateFields(List<T> actualList) throws Exception {
    }

    public void validateFields(Object actual, Map<String, String> parameters) throws Exception {
    }

    public <T> void validateFields(List<T> actualList, Map<String, String> parameters) throws Exception {
    }
}

