/*
 * Decompiled with CFR 0.152.
 */
package com.crowdar.api.rest;

import com.crowdar.api.rest.APIManager;
import com.crowdar.api.rest.Response;
import com.crowdar.core.PropertyManager;
import com.crowdar.core.Utils;
import com.crowdar.util.MapUtils;
import cucumber.api.java.en.And;
import cucumber.api.java.en.Then;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;

public class CommonSteps {
    private Class objectClass;
    private Object actualJsonResponse;
    private Object expectedJsonResponse;
    private final String STATUS_CODE_ERROR = "Status code are not equals.";
    private final String GET_ENTITY_SERVICE_METHOD_NAME = "getEntityService";

    @Then(value="se obtuvo el status code (.*)")
    @And(value="status code (.*) is obtained")
    public void iWillGetTheProperStatusCodeStatusCode(int expStatusCode) {
        int actualStatusCode = APIManager.getLastResponse().getStatusCode();
        Assert.assertEquals((int)actualStatusCode, (int)expStatusCode, (String)"Status code are not equals.");
    }

    @Then(value="no se obtuvo ningun response")
    @And(value="not response at all is obtained")
    public void verifyNullResponse() {
        Object actualJsonResponse = this.getActualResponse();
        Assert.assertEquals((Object)actualJsonResponse, null);
    }

    @Then(value="se obtuvo el response vac\u00edo")
    @And(value="response is empty")
    public void verifyEmptyResponse() {
        String actualJsonResponse = this.getActualResponse().toString();
        Assert.assertEquals((Object)actualJsonResponse, (Object)"[]");
    }

    @Then(value="se obtuvo el response de array vac\u00edo")
    @And(value="response array is empty")
    public void verifyEmptyArrayResponse() {
        Object[] actualJsonResponse = (Object[])this.getActualResponse();
        Assert.assertEquals((int)actualJsonResponse.length, (int)0);
    }

    @Then(value="se obtuvo el texto (.*) como response")
    @And(value="text (.*) was obtained in response")
    public void validateTextResponse(String response) {
        Response actualResponse = APIManager.getLastResponse();
        Assert.assertEquals((String)actualResponse.getResponse().toString(), (String)response);
    }

    @Then(value="se obtuvo el response esperado en ([^ ]*) con el ([^ ]*)")
    @And(value="expected response is obtained in '([^']*)' with '([^']*)'")
    public void iWillGetTheProperResponse(String entity, String jsonName) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        this.setInjectorParameters(jsonName);
        this.invokeValidateMethod(entity, this.objectClass, this.objectClass, this.expectedJsonResponse, this.actualJsonResponse);
    }

    @Then(value="se obtuvo el response esperado en ([^ ]*) con el ([^ ]*) y sus parametros ([^ ]*)")
    @And(value="expected response is obtained in '([^']*)' with '([^ ]*)' and the parameters '([^']*)'")
    public void iWillGetTheProperResponseWithParameters(String entity, String jsonName, String inputParameters) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        this.setInjectorParameters(jsonName);
        Map<String, String> parameters = MapUtils.splitIntoMap(inputParameters, ",", ":");
        this.invokeValidateMethod(entity, parameters, this.objectClass, this.objectClass, this.expectedJsonResponse);
    }

    @Then(value="se obtuvo el response esperado en ([^ ]*) modificando el ([^ ]*)")
    @And(value="expected response is obtained in '([^']*)' with '([^']*)' modifying the '([^']*)'")
    public void iWillGetTheProperResponseModified(String entity, String expectedJsonName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException, ClassNotFoundException, InstantiationException {
        this.setInjectorParameters(null);
        this.invokeValidateMethod(entity, String.class, this.objectClass, "response/".concat(expectedJsonName), this.actualJsonResponse);
    }

    @Then(value="se obtuvo el response esperado en ([^ ]*) modificando el ([^ ]*) y sus parametros ([^ ]*)")
    @And(value="expected response is obtained in '([^']*)' modifying the '([^ ]*)' and the parameters '([^']*)'")
    public void iWillGetTheProperResponseModifiedWithParameters(String entity, String expectedJsonName, String inputParameters) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException, ClassNotFoundException, InstantiationException {
        this.setInjectorParameters(null);
        Map<String, String> parameters = MapUtils.splitIntoMap(inputParameters, ",", ":");
        this.invokeValidateMethod(entity, parameters, String.class, this.objectClass, (Object)"response/".concat(expectedJsonName));
    }

    @Then(value="se obtuvo el response esperado en ([^ ]*)")
    @And(value="expected response is obtained in '([^']*)'")
    public void iWillGetTheProperResponseWithObject(String entity) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        this.setInjectorParameters(null);
        this.invokeValidateMethod(entity, "validateFields");
    }

    @Then(value="se obtuvo el response esperado en ([^ ]*) y sus parametros ([^ ]*)")
    @And(value="expected response is obtained in '([^']*)' and the parameters '([^']*)'")
    public void iWillGetTheProperResponseWithObjectAndParameters(String entity, String inputParameters) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException, ClassNotFoundException, InstantiationException {
        this.setInjectorParameters(null);
        Map<String, String> parameters = MapUtils.splitIntoMap(inputParameters, ",", ":");
        this.invokeValidateMethod(entity, this.objectClass, Map.class, this.actualJsonResponse, parameters);
    }

    @Then(value="se obtuvo el response esperado en ([^ ]*) con el metodo ([^ ]*)")
    @And(value="expected response is obtained in '([^']*)' with the method '([^']*)'")
    public void iWillGetTheProperResponseWithObject(String entity, String method) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        this.setInjectorParameters(null);
        this.invokeValidateMethod(entity, method);
    }

    private void invokeValidateMethod(String entity, String method) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        try {
            Class service = this.getServiceClass(entity);
            service.getMethod(method, this.objectClass).invoke(service.newInstance(), this.actualJsonResponse);
        }
        catch (InvocationTargetException e) {
            Assert.fail((String)e.getCause().toString());
        }
    }

    private void invokeValidateMethod(String entity, Class objectClass, Class objectClass2, Object expectedJsonResponse, Object actualJsonResponse) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        try {
            Class service = this.getServiceClass(entity);
            service.getMethod("validateFields", objectClass, objectClass2).invoke(service.newInstance(), expectedJsonResponse, actualJsonResponse);
        }
        catch (InvocationTargetException e) {
            Assert.fail((String)e.getCause().toString());
        }
    }

    private void invokeValidateMethod(String entity, Map<String, String> parameters, Class objectClass, Class objectClass2, Object expectedJsonResponse) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InstantiationException {
        try {
            Class service = this.getServiceClass(entity);
            service.getMethod("validateFields", objectClass, objectClass2, Map.class).invoke(service.newInstance(), expectedJsonResponse, this.actualJsonResponse, parameters);
        }
        catch (InvocationTargetException e) {
            Assert.fail((String)e.getCause().toString());
        }
    }

    private Class getServiceClass(String entity) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> entityCLass = Class.forName(PropertyManager.getProperty("crowdar.api.entityConfiguration"));
        Object entityConfiguration = Enum.valueOf(entityCLass, entity);
        Method method = entityConfiguration.getClass().getMethod("getEntityService", new Class[0]);
        method.setAccessible(true);
        return (Class)method.invoke(entityConfiguration, new Object[0]);
    }

    private void setInjectorParameters(String expectedJsonName) throws IOException {
        if (this.getActualResponse().getClass().isArray()) {
            this.actualJsonResponse = Utils.parseArrayToList((Object[])this.getActualResponse());
            this.objectClass = List.class;
            if (!StringUtils.isEmpty((String)expectedJsonName)) {
                Class<?> responseClass = this.getResponseClass((List)this.actualJsonResponse);
                this.expectedJsonResponse = this.getListResponseFromFile(expectedJsonName, responseClass);
            }
        } else {
            this.actualJsonResponse = this.getActualResponse();
            this.objectClass = Object.class;
            if (!StringUtils.isEmpty((String)expectedJsonName)) {
                this.expectedJsonResponse = this.getResponseFromFile(expectedJsonName);
            }
        }
    }

    private Class<?> getResponseClass(List actualJsonResponse) {
        return actualJsonResponse.iterator().next().getClass();
    }

    private List getListResponseFromFile(String jsonName, Class responseClass) throws IOException {
        return APIManager.getListResponseFromJsonFile(jsonName, responseClass);
    }

    private Object getResponseFromFile(String jsonName) throws IOException {
        return APIManager.getResponseFromJsonFile(jsonName, Object.class);
    }

    private Object getActualResponse() {
        return APIManager.getLastResponse().getResponse();
    }
}

