/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs.api;

import com.google.common.base.Strings;
import io.lighty.codecs.xml.DocumentedException;
import io.lighty.codecs.xml.XmlElement;
import io.lighty.codecs.xml.XmlUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Deprecated(forRemoval=true)
public final class ConverterUtils {
    private ConverterUtils() {
        throw new UnsupportedOperationException("Do not create an instance of utility class");
    }

    public static Optional<? extends RpcDefinition> loadRpc(SchemaContext schemaContext, QName rpcQName) {
        Optional<Module> findModule = ConverterUtils.findModule(schemaContext, rpcQName);
        if (!findModule.isPresent()) {
            return Optional.empty();
        }
        return ConverterUtils.findDefinition(rpcQName, findModule.get().getRpcs());
    }

    public static Optional<? extends NotificationDefinition> loadNotification(SchemaContext schemaContext, QName notificationQname) {
        Optional<Module> findModule = ConverterUtils.findModule(schemaContext, notificationQname);
        if (!findModule.isPresent()) {
            return Optional.empty();
        }
        return ConverterUtils.findDefinition(notificationQname, findModule.get().getNotifications());
    }

    public static Optional<QName> getRpcQName(XmlElement xmlElement) {
        String[] split;
        Optional optionalNamespace = xmlElement.getNamespaceOptionally().toJavaUtil();
        String name = xmlElement.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        String revision = null;
        if (optionalNamespace.isPresent() && !Strings.isNullOrEmpty((String)((String)optionalNamespace.get()))) {
            split = ((String)optionalNamespace.get()).split("\\?");
            if (split.length > 1 && split[1].contains("revision=")) {
                revision = split[1].replace("revision=", "");
            }
        } else {
            return Optional.of(QName.create((String)name));
        }
        String namespace = split[0];
        if (Strings.isNullOrEmpty(revision)) {
            return Optional.of(QName.create((String)namespace, (String)name));
        }
        return Optional.of(QName.create((String)namespace, revision, (String)name));
    }

    public static Optional<QName> getRpcQName(String inputString) {
        try {
            return ConverterUtils.getRpcQName(XmlElement.fromString(inputString));
        }
        catch (DocumentedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static XmlElement rpcAsInput(XmlElement inputXmlElement) {
        return ConverterUtils.rpcAsInput(inputXmlElement, "");
    }

    public static XmlElement rpcAsInput(XmlElement inputXmlElement, String namespace) {
        return ConverterUtils.wrapNodes("input", namespace, inputXmlElement.getChildElements());
    }

    public static XmlElement rpcAsOutput(XmlElement inputXmlElement) {
        return ConverterUtils.rpcAsOutput(inputXmlElement, "");
    }

    public static XmlElement rpcAsOutput(XmlElement inputXmlElement, String namespace) {
        return ConverterUtils.wrapNodes("output", namespace, inputXmlElement.getChildElements());
    }

    public static SchemaNode getSchemaNode(SchemaContext schemaContext, QName qname) {
        return DataSchemaContextTree.from((SchemaContext)schemaContext).getChild(YangInstanceIdentifier.of((QName)qname)).getDataSchemaNode();
    }

    public static SchemaNode getSchemaNode(SchemaContext schemaContext, YangInstanceIdentifier yangInstanceIdentifier) {
        return DataSchemaContextTree.from((SchemaContext)schemaContext).getChild(yangInstanceIdentifier).getDataSchemaNode();
    }

    public static SchemaNode getSchemaNode(SchemaContext schemaContext, String namespace, String revision, String localName) {
        QName qname = QName.create((String)namespace, (String)revision, (String)localName);
        return DataSchemaContextTree.from((SchemaContext)schemaContext).getChild(YangInstanceIdentifier.of((QName)qname)).getDataSchemaNode();
    }

    private static XmlElement wrapNodes(String nodeName, String namespace, Collection<XmlElement> children) {
        Document document;
        StringBuilder sb = new StringBuilder("<").append(nodeName).append(" xmlns=\"").append(namespace).append("\"/>");
        try {
            document = XmlUtil.readXmlToDocument(sb.toString());
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException(e);
        }
        children.forEach(child -> {
            Node importedNode = document.importNode(child.getDomElement(), true);
            document.getChildNodes().item(0).appendChild(importedNode);
        });
        return XmlElement.fromDomDocument(document);
    }

    private static Optional<Module> findModule(SchemaContext schemaContext, QName qname) {
        if (qname.getRevision().isPresent()) {
            return schemaContext.findModule(qname.getNamespace(), qname.getRevision());
        }
        Collection moduleByNamespace = schemaContext.findModules(qname.getNamespace());
        return Optional.ofNullable(moduleByNamespace.isEmpty() || moduleByNamespace.size() > 1 ? null : (Module)moduleByNamespace.iterator().next());
    }

    private static <T extends SchemaNode> Optional<T> findDefinition(QName qname, Collection<T> nodes) {
        List foundNodes = nodes.stream().filter(node -> node.getQName().getLocalName().equals(qname.getLocalName())).collect(Collectors.toList());
        return Optional.ofNullable(foundNodes.isEmpty() || foundNodes.size() > 1 ? null : (SchemaNode)foundNodes.get(0));
    }
}

