/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@Deprecated(forRemoval=true)
public class DeserializeIdentifierCodec {
    private final DataSchemaContextTree dataSchemaContextTree;
    private final SchemaContext schemaContext;

    public DeserializeIdentifierCodec(SchemaContext schemaContext) {
        this.schemaContext = schemaContext;
        this.dataSchemaContextTree = DataSchemaContextTree.from((SchemaContext)schemaContext);
    }

    public final String deserialize(YangInstanceIdentifier identifier) {
        Optional module;
        String revision;
        List pathArguments = identifier.getPathArguments();
        QName nodeType = ((YangInstanceIdentifier.PathArgument)pathArguments.get(0)).getNodeType();
        ArrayList<String> elements = new ArrayList<String>();
        DataSchemaContextNode current = this.dataSchemaContextTree.getRoot();
        for (YangInstanceIdentifier.PathArgument arg : pathArguments) {
            Preconditions.checkArgument(((current = current.getChild(arg)) != null ? 1 : 0) != 0, (String)"Invalid input %s: schema for argument %s not found", (Object)identifier, (Object)arg);
            if (current.isMixin()) continue;
            if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                elements.add(DeserializeIdentifierCodec.buildListArg(arg, current.getDataSchemaNode()));
                continue;
            }
            if (arg instanceof YangInstanceIdentifier.NodeWithValue) {
                elements.add(DeserializeIdentifierCodec.buildLeafListArg(arg));
                continue;
            }
            elements.add(arg.getNodeType().getLocalName());
        }
        Optional moduleRevision = nodeType.getRevision();
        if (moduleRevision.isPresent()) {
            revision = ((Revision)moduleRevision.get()).toString();
            module = this.schemaContext.findModule(nodeType.getNamespace(), (Revision)moduleRevision.get());
        } else {
            revision = "[not present]";
            module = this.schemaContext.findModule(nodeType.getNamespace());
        }
        if (!module.isPresent()) {
            throw new IllegalStateException("Module with namespace " + nodeType.getNamespace() + " and revision " + revision + " not found");
        }
        return "/" + ((Module)module.get()).getName() + ":" + String.join((CharSequence)"/", elements);
    }

    private static String buildLeafListArg(YangInstanceIdentifier.PathArgument pathArgument) {
        Preconditions.checkState((boolean)(pathArgument instanceof YangInstanceIdentifier.NodeWithValue));
        YangInstanceIdentifier.NodeWithValue node = (YangInstanceIdentifier.NodeWithValue)pathArgument;
        return node.getNodeType().getLocalName() + "=" + node.getValue();
    }

    private static String buildListArg(YangInstanceIdentifier.PathArgument pathArgument, DataSchemaNode schemaNode) {
        YangInstanceIdentifier.NodeIdentifierWithPredicates listId = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument;
        Preconditions.checkState((boolean)(schemaNode instanceof ListSchemaNode));
        ListSchemaNode listSchemaNode = (ListSchemaNode)schemaNode;
        List keyDefinition = listSchemaNode.getKeyDefinition();
        StringBuilder builder = new StringBuilder(listId.getNodeType().getLocalName());
        builder.append("=");
        ArrayList<String> keyValue = new ArrayList<String>();
        for (QName qname : keyDefinition) {
            Object value = listId.getValue(qname);
            if (value == null) {
                throw new IllegalStateException("all key values must be present");
            }
            keyValue.add(value.toString());
        }
        builder.append(String.join((CharSequence)",", keyValue));
        return builder.toString();
    }
}

