/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.lighty.codecs.DeserializeIdentifierCodec;
import io.lighty.codecs.JsonNodeConverter;
import io.lighty.codecs.SerializeIdentifierCodec;
import io.lighty.codecs.XmlNodeConverter;
import io.lighty.codecs.api.Codec;
import io.lighty.codecs.api.NodeConverter;
import io.lighty.codecs.xml.XmlElement;
import io.lighty.codecs.xml.XmlUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.adapter.ConstantAdapterContext;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.restconf.common.errors.RestconfDocumentedException;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataSchemaNode;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Deprecated(forRemoval=true)
public class DataCodec<T extends DataObject>
implements Codec<T> {
    private static final XMLOutputFactory XML_FACTORY = XMLOutputFactory.newInstance();
    private final BindingNormalizedNodeSerializer codec;
    private final DeserializeIdentifierCodec deserializeIdentifierCodec;
    private final SerializeIdentifierCodec serializeIdentifierCodec;
    private final JsonNodeConverter jsonNodeConverter;
    private final XmlNodeConverter xmlNodeConverter;
    private final EffectiveModelContext effectiveModelContext;

    public DataCodec(BindingDOMCodecServices codecServices) {
        ConstantAdapterContext constantAdapterContext = new ConstantAdapterContext(codecServices);
        this.codec = constantAdapterContext.currentSerializer();
        this.effectiveModelContext = codecServices.getRuntimeContext().getEffectiveModelContext();
        this.deserializeIdentifierCodec = new DeserializeIdentifierCodec((SchemaContext)this.effectiveModelContext);
        this.serializeIdentifierCodec = new SerializeIdentifierCodec((SchemaContext)this.effectiveModelContext);
        this.xmlNodeConverter = new XmlNodeConverter(this.effectiveModelContext);
        this.jsonNodeConverter = new JsonNodeConverter((SchemaContext)this.effectiveModelContext);
    }

    @Override
    public @Nullable T convertToBindingAwareData(YangInstanceIdentifier identifier, NormalizedNode<?, ?> data) {
        Map.Entry dataObjectEntry = this.codec.fromNormalizedNode(identifier, data);
        if (dataObjectEntry != null) {
            return (T)((DataObject)dataObjectEntry.getValue());
        }
        return null;
    }

    @Override
    public Collection<T> convertBindingAwareList(YangInstanceIdentifier identifier, MapNode mapNode) {
        Collection children = mapNode.getValue();
        ImmutableList.Builder listBuilder = ImmutableList.builderWithExpectedSize((int)children.size());
        for (MapEntryNode entry : children) {
            listBuilder.add(this.verifyNotNull(this.convertToBindingAwareData(identifier, (NormalizedNode<?, ?>)entry), identifier));
        }
        return listBuilder.build();
    }

    private T verifyNotNull(T dataObject, YangInstanceIdentifier identifier) {
        if (dataObject == null) {
            throw new VerifyException("Unexpected null value for list IID " + identifier);
        }
        return dataObject;
    }

    @Override
    public YangInstanceIdentifier deserializeIdentifier(InstanceIdentifier<T> identifier) {
        return this.codec.toYangInstanceIdentifier(identifier);
    }

    @Override
    public String deserializeIdentifier(YangInstanceIdentifier identifier) {
        return this.deserializeIdentifierCodec.deserialize(identifier);
    }

    @Override
    public YangInstanceIdentifier convertIdentifier(String identifier) {
        return this.serializeIdentifierCodec.serialize(identifier);
    }

    @Override
    public Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> convertToNormalizedNode(InstanceIdentifier<T> identifier, T data) {
        return this.codec.toNormalizedNode(identifier, data);
    }

    @Override
    public T convertToBindingAwareRpc(SchemaPath schemaPath, ContainerNode rpcData) {
        return (T)this.codec.fromNormalizedNodeRpcData(schemaPath, rpcData);
    }

    @Override
    public T convertToBindingAwareNotification(SchemaPath schemaPath, ContainerNode norificationData) {
        return (T)((DataObject)this.codec.fromNormalizedNodeNotification(schemaPath, norificationData));
    }

    @Override
    public ContainerNode convertToBindingIndependentRpc(DataContainer rpcData) {
        return this.codec.toNormalizedNodeRpcData(rpcData);
    }

    @Override
    public ContainerNode convertToBindingIndependentNotification(Notification notificationData) {
        return this.codec.toNormalizedNodeNotification(notificationData);
    }

    @Override
    public NormalizedNode<?, ?> serializeXMLError(String body) {
        NormalizedNode normalizedNode;
        block9: {
            Optional restconfRevision = Revision.ofNullable((String)"2017-01-26");
            Optional optModule = this.effectiveModelContext.findModule("ietf-restconf", restconfRevision);
            if (!optModule.isPresent()) {
                throw new IllegalStateException("ietf-restconf module was not found in schema context.");
            }
            Module restconfModule = (Module)optModule.get();
            Collection unknownSchemaNodes = restconfModule.getUnknownSchemaNodes();
            QNameModule qNameRestconfModule = QNameModule.create((URI)URI.create("urn:ietf:params:xml:ns:yang:ietf-restconf"), (Optional)restconfRevision);
            QName yangDataYangErrors = QName.create((QNameModule)qNameRestconfModule, (String)"yang-errors");
            YangDataSchemaNode yangDataNode = (YangDataSchemaNode)unknownSchemaNodes.stream().filter(unknownSchemaNode -> yangDataYangErrors.equals((Object)unknownSchemaNode.getQName())).findFirst().orElseThrow(() -> new IllegalStateException("node yang-error wasn't found in ietf-restconf "));
            ContainerSchemaNode schemaNode = yangDataNode.getContainerSchemaNode();
            NormalizedNodeResult resultHolder = new NormalizedNodeResult();
            NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
            XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (EffectiveModelContext)this.effectiveModelContext, (SchemaNode)schemaNode);
            try {
                Document doc = XmlUtil.readXmlToDocument(body);
                XmlElement element = XmlElement.fromDomDocument(doc);
                Element domElement = element.getDomElement();
                xmlParser.traverse(new DOMSource(domElement));
                normalizedNode = resultHolder.getResult();
                if (xmlParser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlParser != null) {
                        try {
                            xmlParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException | XMLStreamException | SAXException e) {
                    throw new RestconfDocumentedException(e.getMessage(), (Throwable)e);
                }
            }
            xmlParser.close();
        }
        return normalizedNode;
    }

    @Override
    public BindingNormalizedNodeSerializer getCodec() {
        return this.codec;
    }

    @Override
    public EffectiveModelContext getEffectiveModelContext() {
        return this.effectiveModelContext;
    }

    @Override
    public NodeConverter withJson() {
        return this.jsonNodeConverter;
    }

    @Override
    public NodeConverter withXml() {
        return this.xmlNodeConverter;
    }

    static {
        XML_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

