/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs.xml;

import io.lighty.codecs.xml.ModuleIdentifier;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidationException
extends Exception {
    private static final long serialVersionUID = -6072893219820274247L;
    private final Map<String, Map<String, ExceptionMessageWithStackTrace>> failedValidations;

    public ValidationException(Map<String, Map<String, ExceptionMessageWithStackTrace>> failedValidations) {
        super(failedValidations.toString());
        this.failedValidations = Collections.unmodifiableMap(failedValidations);
    }

    public static ValidationException createFromCollectedValidationExceptions(List<ValidationException> collectedExceptions) {
        HashMap<String, Map<String, ExceptionMessageWithStackTrace>> failedValidations = new HashMap<String, Map<String, ExceptionMessageWithStackTrace>>();
        for (ValidationException ve : collectedExceptions) {
            for (Map.Entry<String, Map<String, ExceptionMessageWithStackTrace>> outerEntry : ve.getFailedValidations().entrySet()) {
                for (Map.Entry<String, ExceptionMessageWithStackTrace> innerEntry : outerEntry.getValue().entrySet()) {
                    String moduleName = outerEntry.getKey();
                    String instanceName = innerEntry.getKey();
                    ExceptionMessageWithStackTrace ex = innerEntry.getValue();
                    Map instanceToExMap = failedValidations.computeIfAbsent(moduleName, k -> new HashMap());
                    if (instanceToExMap.containsKey(instanceName)) {
                        throw new IllegalArgumentException("Cannot merge with same module name " + moduleName + " and instance name " + instanceName);
                    }
                    instanceToExMap.put(instanceName, ex);
                }
            }
        }
        return new ValidationException(failedValidations);
    }

    public static ValidationException createForSingleException(ModuleIdentifier moduleIdentifier, Exception exception) {
        HashMap<String, Map<String, ExceptionMessageWithStackTrace>> failedValidations = new HashMap<String, Map<String, ExceptionMessageWithStackTrace>>();
        HashMap<String, ExceptionMessageWithStackTrace> innerMap = new HashMap<String, ExceptionMessageWithStackTrace>();
        failedValidations.put(moduleIdentifier.getFactoryName(), innerMap);
        innerMap.put(moduleIdentifier.getInstanceName(), new ExceptionMessageWithStackTrace(exception));
        return new ValidationException(failedValidations);
    }

    public Map<String, Map<String, ExceptionMessageWithStackTrace>> getFailedValidations() {
        return this.failedValidations;
    }

    public static class ExceptionMessageWithStackTrace
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String message;
        private String stackTrace;

        public ExceptionMessageWithStackTrace() {
        }

        public ExceptionMessageWithStackTrace(String message, String stackTrace) {
            this.message = message;
            this.stackTrace = stackTrace;
        }

        public ExceptionMessageWithStackTrace(Exception exception) {
            this(exception.getMessage(), Arrays.toString(exception.getStackTrace()));
        }

        public String getMessage() {
            return this.message;
        }

        public String getTrace() {
            return this.stackTrace;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setStackTrace(String trace) {
            this.stackTrace = trace;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.stackTrace == null ? 0 : this.stackTrace.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExceptionMessageWithStackTrace other = (ExceptionMessageWithStackTrace)obj;
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            return !(this.stackTrace == null ? other.stackTrace != null : !this.stackTrace.equals(other.stackTrace));
        }

        public String toString() {
            return this.message;
        }
    }
}

