/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs.util;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lighty.codecs.util.NodeConverter;
import io.lighty.codecs.util.exception.DeserializationException;
import io.lighty.codecs.util.exception.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNodeConverter
implements NodeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNodeConverter.class);
    private final JSONCodecFactory jsonCodecFactory;

    public JsonNodeConverter(EffectiveModelContext effectiveModelContext) {
        this(effectiveModelContext, JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02);
    }

    public JsonNodeConverter(EffectiveModelContext effectiveModelContext, JSONCodecFactorySupplier jsonCodecFactorySupplier) {
        this.jsonCodecFactory = jsonCodecFactorySupplier.createLazy(effectiveModelContext);
    }

    @Override
    public Writer serializeData(SchemaInferenceStack.Inference inference, NormalizedNode normalizedNode) throws SerializationException {
        StringWriter writer = new StringWriter();
        XMLNamespace initialNamespace = normalizedNode.getIdentifier().getNodeType().getNamespace();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        boolean useNested = normalizedNode instanceof MapEntryNode;
        NormalizedNodeStreamWriter nnStreamWriter = useNested ? JSONNormalizedNodeStreamWriter.createNestedWriter((JSONCodecFactory)this.jsonCodecFactory, (EffectiveStatementInference)inference, (XMLNamespace)initialNamespace, (JsonWriter)jsonWriter) : JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)this.jsonCodecFactory, (EffectiveStatementInference)inference, (XMLNamespace)initialNamespace, (JsonWriter)jsonWriter);
        try {
            StringWriter stringWriter;
            block16: {
                NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter);
                try {
                    nnWriter.write(normalizedNode);
                    stringWriter = writer;
                    if (nnWriter == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (nnWriter != null) {
                            try {
                                nnWriter.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new SerializationException(e);
                    }
                }
                nnWriter.close();
            }
            return stringWriter;
        }
        finally {
            if (useNested) {
                try {
                    jsonWriter.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close underlying JsonWriter", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Writer serializeRpc(SchemaInferenceStack.Inference inference, NormalizedNode normalizedNode) throws SerializationException {
        StringWriter stringWriter;
        block9: {
            Preconditions.checkState((boolean)(normalizedNode instanceof ContainerNode), (Object)"RPC input/output to serialize is expected to be a ContainerNode");
            XMLNamespace namespace = normalizedNode.getIdentifier().getNodeType().getNamespace();
            String localName = normalizedNode.getIdentifier().getNodeType().getLocalName();
            StringWriter writer = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            NormalizedNodeStreamWriter nnStreamWriter = JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)this.jsonCodecFactory, (EffectiveStatementInference)inference, (XMLNamespace)namespace, (JsonWriter)jsonWriter);
            NormalizedNodeWriter normalizedNodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter);
            try {
                jsonWriter.beginObject().name(localName);
                for (NormalizedNode child : ((ContainerNode)normalizedNode).body()) {
                    normalizedNodeWriter.write(child);
                }
                jsonWriter.endObject();
                stringWriter = writer;
                if (normalizedNodeWriter == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (normalizedNodeWriter != null) {
                        try {
                            normalizedNodeWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SerializationException(e);
                }
            }
            normalizedNodeWriter.close();
        }
        return stringWriter;
    }

    @Override
    public NormalizedNode deserialize(SchemaInferenceStack.Inference inference, Reader inputData) throws DeserializationException {
        if (inference.statementPath().isEmpty()) {
            DataContainerNodeBuilder resultBuilder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME));
            this.parseToResult(ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeContainerBuilder)resultBuilder), inputData, inference);
            return resultBuilder.build();
        }
        NormalizedNodeResult result = new NormalizedNodeResult();
        this.parseToResult(ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result), inputData, inference);
        return result.getResult();
    }

    private void parseToResult(NormalizedNodeStreamWriter writer, Reader data, SchemaInferenceStack.Inference inference) throws DeserializationException {
        try (JsonReader reader = new JsonReader(data);
             JsonParserStream jsonParser = JsonParserStream.create((NormalizedNodeStreamWriter)writer, (JSONCodecFactory)this.jsonCodecFactory, (EffectiveStatementInference)inference);){
            jsonParser.parse(reader);
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public EffectiveModelContext getModelContext() {
        return this.jsonCodecFactory.getEffectiveModelContext();
    }
}

