/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs.util;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class ConverterUtils {
    private ConverterUtils() {
        throw new UnsupportedOperationException("Do not create an instance of utility class");
    }

    public static Optional<? extends RpcDefinition> loadRpc(EffectiveModelContext effectiveModelContext, QName rpcQName) {
        Optional<Module> findModule = ConverterUtils.findModule(effectiveModelContext, rpcQName);
        if (findModule.isEmpty()) {
            return Optional.empty();
        }
        return ConverterUtils.findDefinition(rpcQName, findModule.get().getRpcs());
    }

    public static Optional<? extends NotificationDefinition> loadNotification(EffectiveModelContext effectiveModelContext, QName notificationQname) {
        Optional<Module> findModule = ConverterUtils.findModule(effectiveModelContext, notificationQname);
        if (!findModule.isPresent()) {
            return Optional.empty();
        }
        return ConverterUtils.findDefinition(notificationQname, findModule.get().getNotifications());
    }

    public static Optional<QName> getRpcQName(XmlElement xmlElement) {
        String[] split;
        Optional optionalNamespace = xmlElement.getNamespaceOptionally();
        String name = xmlElement.getName();
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        String revision = null;
        if (optionalNamespace.isPresent() && !Strings.isNullOrEmpty((String)((String)optionalNamespace.get()))) {
            split = ((String)optionalNamespace.get()).split("\\?");
            if (split.length > 1 && split[1].contains("revision=")) {
                revision = split[1].replace("revision=", "");
            }
        } else {
            return Optional.of(QName.create((String)name));
        }
        String namespace = split[0];
        if (Strings.isNullOrEmpty(revision)) {
            return Optional.of(QName.create((String)namespace, (String)name));
        }
        return Optional.of(QName.create((String)namespace, revision, (String)name));
    }

    public static Optional<QName> getRpcQName(String inputString) {
        try {
            return ConverterUtils.getRpcQName(XmlElement.fromString((String)inputString));
        }
        catch (DocumentedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static XmlElement rpcAsInput(XmlElement inputXmlElement) {
        return ConverterUtils.rpcAsInput(inputXmlElement, "");
    }

    public static XmlElement rpcAsInput(XmlElement inputXmlElement, String namespace) {
        return ConverterUtils.wrapNodes("input", namespace, inputXmlElement.getChildElements());
    }

    public static XmlElement rpcAsOutput(XmlElement inputXmlElement) {
        return ConverterUtils.rpcAsOutput(inputXmlElement, "");
    }

    public static XmlElement rpcAsOutput(XmlElement inputXmlElement, String namespace) {
        return ConverterUtils.wrapNodes("output", namespace, inputXmlElement.getChildElements());
    }

    public static Optional<@NonNull DataSchemaContextNode<?>> getSchemaNode(EffectiveModelContext effectiveModelContext, QName qname) {
        return ConverterUtils.getSchemaNode(effectiveModelContext, YangInstanceIdentifier.of((QName)qname));
    }

    public static Optional<@NonNull DataSchemaContextNode<?>> getSchemaNode(EffectiveModelContext effectiveModelContext, YangInstanceIdentifier yangInstanceIdentifier) {
        return DataSchemaContextTree.from((EffectiveModelContext)effectiveModelContext).findChild(yangInstanceIdentifier);
    }

    public static Optional<@NonNull DataSchemaContextNode<?>> getSchemaNode(EffectiveModelContext effectiveModelContext, String namespace, String revision, String localName) {
        return ConverterUtils.getSchemaNode(effectiveModelContext, QName.create((String)namespace, (String)revision, (String)localName));
    }

    public static SchemaInferenceStack.Inference toInference(YangInstanceIdentifier yangInstanceIdentifier, EffectiveModelContext effectiveModelContext) {
        return ((DataSchemaContextTree.NodeAndStack)DataSchemaContextTree.from((EffectiveModelContext)effectiveModelContext).enterPath(Objects.requireNonNull(yangInstanceIdentifier)).orElseThrow()).stack().toInference();
    }

    private static XmlElement wrapNodes(String nodeName, String namespace, Collection<XmlElement> children) {
        Document document;
        StringBuilder sb = new StringBuilder("<").append(nodeName).append(" xmlns=\"").append(namespace).append("\"/>");
        try {
            document = XmlUtil.readXmlToDocument((String)sb.toString());
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException(e);
        }
        children.forEach(child -> {
            Node importedNode = document.importNode(child.getDomElement(), true);
            document.getChildNodes().item(0).appendChild(importedNode);
        });
        return XmlElement.fromDomDocument((Document)document);
    }

    private static Optional<Module> findModule(EffectiveModelContext effectiveModelContext, QName qname) {
        if (qname.getRevision().isPresent()) {
            return effectiveModelContext.findModule(qname.getNamespace(), qname.getRevision());
        }
        Collection moduleByNamespace = effectiveModelContext.findModules(qname.getNamespace());
        return Optional.ofNullable(moduleByNamespace.isEmpty() || moduleByNamespace.size() > 1 ? null : (Module)moduleByNamespace.iterator().next());
    }

    private static <T extends SchemaNode> Optional<T> findDefinition(QName qname, Collection<T> nodes) {
        List foundNodes = nodes.stream().filter(node -> node.getQName().getLocalName().equals(qname.getLocalName())).collect(Collectors.toList());
        return Optional.ofNullable(foundNodes.size() != 1 ? null : (SchemaNode)foundNodes.get(0));
    }
}

