/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs.util;

import io.lighty.codecs.util.NodeConverter;
import io.lighty.codecs.util.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlNodeConverter
implements NodeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlNodeConverter.class);
    private static final XMLInputFactory XML_IN_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory XML_OUT_FACTORY = XMLOutputFactory.newFactory();
    private final EffectiveModelContext effectiveModelContext;

    public XmlNodeConverter(EffectiveModelContext effectiveModelContext) {
        this.effectiveModelContext = effectiveModelContext;
    }

    @Override
    public Writer serializeData(SchemaNode schemaNode, NormalizedNode normalizedNode) throws SerializationException {
        StringWriter writer = new StringWriter();
        try (NormalizedNodeWriter normalizedNodeWriter = XmlNodeConverter.createNormalizedNodeWriter(this.effectiveModelContext, writer, schemaNode.getPath());){
            normalizedNodeWriter.write(normalizedNode);
            normalizedNodeWriter.flush();
        }
        catch (IOException ioe) {
            throw new SerializationException(ioe);
        }
        return writer;
    }

    @Override
    public Writer serializeRpc(SchemaNode schemaNode, NormalizedNode normalizedNode) throws SerializationException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlStreamWriter = XmlNodeConverter.createXmlStreamWriter(writer);
        XMLNamespace namespace = schemaNode.getQName().getNamespace();
        String localName = schemaNode.getQName().getLocalName();
        try (NormalizedNodeWriter normalizedNodeWriter = XmlNodeConverter.createNormalizedNodeWriter(this.effectiveModelContext, xmlStreamWriter, schemaNode.getPath());){
            xmlStreamWriter.writeStartElement("", localName, namespace.toString());
            xmlStreamWriter.writeDefaultNamespace(namespace.toString());
            for (NormalizedNode child : ((ContainerNode)normalizedNode).body()) {
                normalizedNodeWriter.write(child);
            }
            normalizedNodeWriter.flush();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.flush();
        }
        catch (IOException | XMLStreamException ioe) {
            throw new SerializationException(ioe);
        }
        return writer;
    }

    @Override
    public NormalizedNode deserialize(SchemaNode schemaNode, Reader inputData) throws SerializationException {
        XMLStreamReader reader;
        try {
            reader = XML_IN_FACTORY.createXMLStreamReader(inputData);
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        SchemaInferenceStack.Inference inference = SchemaInferenceStack.ofSchemaPath((EffectiveModelContext)this.effectiveModelContext, (SchemaPath)schemaNode.getPath()).toInference();
        NormalizedNodeResult result = new NormalizedNodeResult();
        try (NormalizedNodeStreamWriter streamWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
             XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)streamWriter, (EffectiveStatementInference)inference);){
            xmlParser.parse(reader);
        }
        catch (IOException | URISyntaxException | XMLStreamException | SAXException e) {
            throw new SerializationException(e);
        }
        finally {
            XmlNodeConverter.closeQuietly(reader);
        }
        return result.getResult();
    }

    private static NormalizedNodeWriter createNormalizedNodeWriter(EffectiveModelContext effectiveModelContext, Writer backingWriter, SchemaPath pathToParent) {
        XMLStreamWriter createXMLStreamWriter = XmlNodeConverter.createXmlStreamWriter(backingWriter);
        return XmlNodeConverter.createNormalizedNodeWriter(effectiveModelContext, createXMLStreamWriter, pathToParent);
    }

    private static NormalizedNodeWriter createNormalizedNodeWriter(EffectiveModelContext effectiveModelContext, XMLStreamWriter backingWriter, SchemaPath pathToParent) {
        NormalizedNodeStreamWriter streamWriter = pathToParent == null ? XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)backingWriter, (EffectiveModelContext)effectiveModelContext) : XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)backingWriter, (EffectiveModelContext)effectiveModelContext, (SchemaPath)pathToParent);
        return NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)streamWriter);
    }

    private static XMLStreamWriter createXmlStreamWriter(Writer backingWriter) {
        XMLStreamWriter xmlStreamWriter;
        try {
            xmlStreamWriter = XML_OUT_FACTORY.createXMLStreamWriter(backingWriter);
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        return xmlStreamWriter;
    }

    public static void closeQuietly(XMLStreamReader xmlStreamReader) {
        if (xmlStreamReader != null) {
            try {
                xmlStreamReader.close();
            }
            catch (XMLStreamException e) {
                LOG.warn("Failed to close stream", (Throwable)e);
            }
        }
    }

    static {
        XML_OUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

