/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs.util;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.lighty.codecs.util.NodeConverter;
import io.lighty.codecs.util.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public class JsonNodeConverter
implements NodeConverter {
    private final JSONCodecFactory jsonCodecFactory;

    public JsonNodeConverter(EffectiveModelContext effectiveModelContext) {
        this.jsonCodecFactory = JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.createLazy(effectiveModelContext);
    }

    public JsonNodeConverter(EffectiveModelContext effectiveModelContext, JSONCodecFactorySupplier jsonCodecFactorySupplier) {
        this.jsonCodecFactory = jsonCodecFactorySupplier.createLazy(effectiveModelContext);
    }

    @Override
    public Writer serializeData(SchemaNode schemaNode, NormalizedNode normalizedNode) throws SerializationException {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        XMLNamespace namespace = schemaNode.getQName().getNamespace();
        NormalizedNodeStreamWriter create = JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)this.jsonCodecFactory, (SchemaPath)schemaNode.getPath(), (XMLNamespace)namespace, (JsonWriter)jsonWriter);
        try (NormalizedNodeWriter normalizedNodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)create);){
            normalizedNodeWriter.write(normalizedNode);
            jsonWriter.flush();
        }
        catch (IOException ioe) {
            throw new SerializationException(ioe);
        }
        return writer;
    }

    @Override
    public Writer serializeRpc(SchemaNode schemaNode, NormalizedNode normalizedNode) throws SerializationException {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        String localName = schemaNode.getQName().getLocalName();
        XMLNamespace namespace = schemaNode.getQName().getNamespace();
        NormalizedNodeStreamWriter create = JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)this.jsonCodecFactory, (SchemaPath)schemaNode.getPath(), (XMLNamespace)namespace, (JsonWriter)jsonWriter);
        try (NormalizedNodeWriter normalizedNodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)create);){
            jsonWriter.beginObject().name(localName);
            for (NormalizedNode child : ((ContainerNode)normalizedNode).body()) {
                normalizedNodeWriter.write(child);
            }
            if (!((Object)writer).toString().endsWith("}")) {
                jsonWriter.endObject();
            }
        }
        catch (IOException ioe) {
            throw new SerializationException(ioe);
        }
        return writer;
    }

    @Override
    public NormalizedNode deserialize(SchemaNode schemaNode, Reader inputData) throws SerializationException {
        SchemaInferenceStack.Inference inference = SchemaInferenceStack.ofSchemaPath((EffectiveModelContext)this.jsonCodecFactory.getEffectiveModelContext(), (SchemaPath)schemaNode.getPath()).toInference();
        NormalizedNodeResult result = new NormalizedNodeResult();
        try (JsonReader reader = new JsonReader(inputData);
             NormalizedNodeStreamWriter streamWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
             JsonParserStream jsonParser = JsonParserStream.create((NormalizedNodeStreamWriter)streamWriter, (JSONCodecFactory)this.jsonCodecFactory, (EffectiveStatementInference)inference);){
            jsonParser.parse(reader);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return result.getResult();
    }
}

