/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.cluster.kubernetes;

import akka.actor.AbstractActor;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.japi.Creator;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ClusterAdminService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveAllShardReplicasInputBuilder;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberRemovedListener
extends AbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(MemberRemovedListener.class);
    private final Cluster cluster = Cluster.get((ActorSystem)this.getContext().getSystem());
    private final ClusterAdminService clusterAdminRPCService;

    public MemberRemovedListener(ClusterAdminService clusterAdminRPCService) {
        LOG.info("{} created", ((Object)((Object)this)).getClass());
        this.clusterAdminRPCService = clusterAdminRPCService;
    }

    public static Props props(ClusterAdminService clusterAdminRPCService) {
        return Props.create(MemberRemovedListener.class, (Creator & Serializable)() -> new MemberRemovedListener(clusterAdminRPCService));
    }

    public void preStart() {
        LOG.info("Starting {}", ((Object)((Object)this)).getClass());
        this.cluster.subscribe(this.getSelf(), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.initialStateAsEvents(), new Class[]{ClusterEvent.MemberRemoved.class});
    }

    public void postStop() {
        this.cluster.unsubscribe(this.getSelf());
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ClusterEvent.MemberRemoved.class, removedMember -> {
            LOG.info("Member detected as removed, processing: {}", (Object)removedMember.member().address());
            this.processRemovedMember(removedMember.member());
        }).build();
    }

    private void processRemovedMember(Member member) {
        LOG.info("Removing shard replicas for member {}. May result in WARN (DOES_NOT_EXIST) messages if alreadyremoved by another member.", (Object)member.address());
        List removedMemberRoles = member.getRoles().stream().filter(role -> !role.contains("default")).collect(Collectors.toList());
        try {
            for (String removedMemberRole : removedMemberRoles) {
                ListenableFuture rpcResultListenableFuture = this.clusterAdminRPCService.removeAllShardReplicas(new RemoveAllShardReplicasInputBuilder().setMemberName(removedMemberRole).build());
                RpcResult removeAllShardReplicasResult = (RpcResult)rpcResultListenableFuture.get();
                if (removeAllShardReplicasResult.isSuccessful()) {
                    LOG.info("RPC RemoveAllShards for member {} executed successfully", (Object)removedMemberRole);
                    continue;
                }
                LOG.warn("RPC RemoveAllShards for member {} failed: {}", (Object)removedMemberRole, (Object)removeAllShardReplicasResult.getErrors());
            }
            LOG.info("Shard replicas removed for member {}", (Object)member.address());
        }
        catch (ExecutionException e) {
            LOG.error("Unable to remove shard replicas for member {}", (Object)member.address(), (Object)e);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while removing shard replicas for member {}", (Object)member.address(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }
}

