/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.cluster.config;

import com.typesafe.config.Config;
import java.util.List;

public final class ClusteringConfigUtils {
    public static final String MODULE_SHARDS_TMP_PATH = "/tmp/module-shards.conf";
    public static final String AKKA_DISCOVERY_METHOD_PATH = "akka.discovery.method";
    public static final String K8S_DISCOVERY_API_NAME = "kubernetes-api";

    private ClusteringConfigUtils() {
    }

    public static String generateModuleShardsForMembers(List<String> memberRoles) {
        return String.format("module-shards = [%n%s]", String.join((CharSequence)",\n", ClusteringConfigUtils.generateShard("default", memberRoles), ClusteringConfigUtils.generateShard("topology", memberRoles), ClusteringConfigUtils.generateShard("inventory", memberRoles)));
    }

    public static boolean isKubernetesDeployment(Config actorSystemConfig) {
        return actorSystemConfig.hasPath(AKKA_DISCOVERY_METHOD_PATH) && actorSystemConfig.getString(AKKA_DISCOVERY_METHOD_PATH).equalsIgnoreCase(K8S_DISCOVERY_API_NAME);
    }

    private static String generateShard(String name, List<String> replicas) {
        return "    {        name = \"" + name + "\"\n        shards = [\n            {\n                name=\"" + name + "\"\n                replicas = " + replicas + "                \n            }\n        ]\n    }";
    }
}

