/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.cluster.kubernetes;

import akka.Done;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import akka.cluster.Cluster;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.lighty.core.cluster.kubernetes.UnreachableListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ClusterAdminService;

public class UnreachableListenerService
implements ClusterSingletonService {
    private static final String CLUSTER_SINGLETON_ID = "singletonUnreachableListener";
    private final Cluster cluster;
    private final Long podRestartTimeout;
    private final ActorSystem actorSystem;
    private final DataBroker dataBroker;
    private final ClusterAdminService clusterAdminRPCService;
    private ActorRef unreachableListener;

    public UnreachableListenerService(ActorSystem actorSystem, DataBroker dataBroker, ClusterAdminService clusterAdminRPCService, Long podRestartTimeout) {
        this.actorSystem = actorSystem;
        this.dataBroker = dataBroker;
        this.clusterAdminRPCService = clusterAdminRPCService;
        this.cluster = Cluster.get((ActorSystem)actorSystem);
        this.podRestartTimeout = podRestartTimeout;
    }

    public void instantiateServiceInstance() {
        this.unreachableListener = this.actorSystem.actorOf(UnreachableListener.props(this.actorSystem, this.dataBroker, this.clusterAdminRPCService, this.podRestartTimeout), "unreachableListener");
    }

    public ListenableFuture<? extends Object> closeServiceInstance() {
        this.cluster.unsubscribe(this.unreachableListener);
        this.unreachableListener.tell((Object)PoisonPill.getInstance(), this.unreachableListener);
        return Futures.immediateFuture((Object)Done.done());
    }

    public ServiceGroupIdentifier getIdentifier() {
        return ServiceGroupIdentifier.create((String)CLUSTER_SINGLETON_ID);
    }
}

